//+------------------------------------------------------------------+
//|                                                      zuzu.mq4   |
//|                               Copyright  2012, Vitalie Stavila |
//+------------------------------------------------------------------+
  #include <WinUser32.mqh>
#property copyright "Copyright  2012, Vitalie Stavila"
#property link      "flint_md86"
//--------------------------------------------------------------------
extern int     TimeFrame=0;
extern string  iCustomName="SD_alarm";
extern string  iCustomParam="6";
extern int     iBuyBufIndex=0;
extern int     iSellBufIndex=1;
               

double  LOT=0.1;
//--------------------------------------------------------------------
double SL=-1;
double TP=-1;
int TimeBar; //global variable
int ParArr=6;
int iShift=0;
//--------------------------------------------------------------------

int start()
{
   double buyarrow=iCustom(NULL,TimeFrame,iCustomName,6,iBuyBufIndex,iShift);
   double sellarrow=iCustom(NULL,TimeFrame,iCustomName,6,iSellBufIndex,iShift);

   bool BuySignal=false;
   bool SellSignal=false;   

   if(buyarrow!=EMPTY_VALUE && buyarrow!=0){BuySignal=true;Print("buy");}
   if(sellarrow!=EMPTY_VALUE && sellarrow!=0){SellSignal=true;Print("sell");}



   
   
  
   
    
   if (BuySignal) //Buy
   {
      TimeBar=Time[0];                            
      CLOSEORDER("Sell");
      OPENORDER ("Buy");
   }
   if (SellSignal) //Sell
   {
      TimeBar=Time[0];                            
      CLOSEORDER("Buy");
      OPENORDER ("Sell");
   }
return(0);
}
//--------------------------------------------------------------------
void CLOSEORDER(string ord)
{
   for (int i=OrdersTotal()-1; i>=0; i--)
   {                                               
      if (OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==true)
      {
         if (OrderSymbol()!=Symbol()) continue;
         if (OrderType()==OP_BUY && ord=="Buy")
            OrderClose(OrderTicket(),OrderLots(),Bid,3,CLR_NONE);// Close Buy
         if (OrderType()==OP_SELL && ord=="Sell")
            OrderClose(OrderTicket(),OrderLots(),Ask,3,CLR_NONE);// Close Sell
      }   
   }
}
//--------------------------------------------------------------------
void OPENORDER(string ord)
{
   int error;
   if (ord=="Buy" ) error=OrderSend(Symbol(),OP_BUY, LOT,Ask,2,SL,TP,"", 1,3);
   if (ord=="Sell") error=OrderSend(Symbol(),OP_SELL,LOT,Bid,2,SL,TP,"",-1,3);
   if (error==-1) //operation failed
   {  
      ShowERROR(error,0,0);
   }
return;
}                  
//--------------------------------------------------------------------
void ShowERROR(int Ticket,double SL,double TP)
{
   int err=GetLastError();
   switch ( err )
   {                  
      case 1:                                                                               return;
      case 2:   Alert("Error Connection with trade server absent    ",Ticket," ",Symbol());return;
      case 3:   Alert("Error Invalid trade parameters   Ticket ",  Ticket," ",Symbol());return;
      case 130: Alert("Error Invalid stops   Ticket ",             Ticket," ",Symbol());return;
      case 134: Alert("Error Not enough money   ",                 Ticket," ",Symbol());return;
      case 146: Alert("Error Trade context is busy. ",             Ticket," ",Symbol());return;
      case 129: Alert("Error Invalid price ",                      Ticket," ",Symbol());return;
      case 131: Alert("Error Invalid volume ",                     Ticket," ",Symbol());return;
      case 4051:Alert("Error Invalid function parameter value ", Ticket," ",Symbol());return;
      case 4105:Alert("Error No order selected ",                Ticket," ",Symbol());return;
      case 4063:Alert("Error Integer parameter expected ",       Ticket," ",Symbol());return;
      case 4200:Alert("Error    ",            Ticket," ",Symbol());return;
      default:  Alert("Error Object already exists " ,err,"   Ticket ", Ticket," ",Symbol());return;
   }
}
//--------------------------------------------------------------------


