// ForXZ.cpp : Defines the entry point for the DLL application.
//
#include <windows.h>
//#include <stdio.h>
#include <math.h>
//#include <string.h>
//#include <stdlib.h>


//#ifndef FALSE
//#define FALSE 0
//#define TRUE 1
//#endif
//#define MENUCODE -999

#pragma argsused

int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{
  return 1;
}
//---------------------------------------------------------------------------
/* ------------------------------------------------------------------------- */




static double Thresholds[] =
{

/* layer 1 */
1.2145040659995765, 3.7150897132033802, 0.59454351593610577, 0.31822673978973876,

/* layer 2 */
1.0261447433298005

};

static double Weights[] =
{

/* layer 1 */
-1.1141264237664898, -1.5504305146313317, 0.73286159338154766, -1.2788684374991517,
-0.61641073399851731,
0.69072562217776923, -0.22241781292722679, 0.71682200719453848, 0.0017560026910527838,
2.1540691697208927,
-0.99116459059236506, -0.054704110029000053, -1.2382645587627006, -2.9685995454576384,
-1.1411725616914337,
-0.043297251827266285, -0.066167428785390461, -0.020875395803372929, -0.11405333458161644,
1.8579545370330088,

/* layer 2 */
-0.97811177652242753, 2.8971789204781668, -1.8332145813941754, 2.2454948857766635

};

static double Acts[20];

//extern "C" 
__declspec(dllexport) double WINAPI Run ( double inputs[] )
{
  int i, j, k, u;
  double *w = Weights, *t = Thresholds;

  /* Process inputs - apply pre-processing to each input in turn,
  * storing results in the neuron activations array.
  */

  /* Input 0: standard numeric pre-processing: linear shift and scale. */
  if ( inputs[0] == -9999 )
  Acts[0] = 0.35852063342998086;
  else
  Acts[0] = inputs[0] * 7.2056492289955321 + -6.0600951145698216;

  /* Input 1: standard numeric pre-processing: linear shift and scale. */
  if ( inputs[1] == -9999 )
  Acts[1] = 0.35857336433909737;
  else
  Acts[1] = inputs[1] * 7.204610951008644 + -6.0590778097982696;

  /* Input 2: standard numeric pre-processing: linear shift and scale. */
  if ( inputs[2] == -9999 )
  Acts[2] = 0.35851878147446925;
  else
  Acts[2] = inputs[2] * 7.204610951008644 + -6.0590778097982696;

  /* Input 3: standard numeric pre-processing: linear shift and scale. */
  if ( inputs[3] == -9999 )
  Acts[3] = 0.35847796574053348;
  else
  Acts[3] = inputs[3] * 7.204610951008644 + -6.0590778097982696;

  /* Input 4: standard numeric pre-processing: linear shift and scale. */
  if ( inputs[4] == -9999 )
  Acts[4] = 0.35964573508254105;
  else
  Acts[4] = inputs[4] * 7.231703789412788 + -6.0820075209719429;

  /*
  * Process layer 1.
  */

  /* For each unit in turn */
  for ( u=0; u < 4; ++u )
  {
  /*
  * First, calculate post-synaptic potentials, storing
  * these in the Acts array.
  */

  /* Initialise hidden unit activation to zero */
  Acts[5+u] = 0.0;

  /* Accumulate weighted sum from inputs */
  for ( i=0; i < 5; ++i )
  Acts[5+u] += *w++ * Acts[0+i];

  /* Subtract threshold */
  Acts[5+u] -= *t++;

  /* Now apply the hyperbolic activation function, ( e^x - e^-x ) / ( e^x + e^-x ).
  * Deal with overflow and underflow
  */
  if ( Acts[5+u] > 100.0 )
  Acts[5+u] = 1.0;
  else if ( Acts[5+u] < -100.0 )
  Acts[5+u] = -1.0;
  else
  {
  double e1 = exp( Acts[5+u] ), e2 = exp( -Acts[5+u] );
  Acts[5+u] = ( e1 - e2 ) / ( e1 + e2 );
  }
  }

  /*
  * Process layer 2.
  */

  /* For each unit in turn */
  for ( u=0; u < 1; ++u )
  {
  /*
  * First, calculate post-synaptic potentials, storing
  * these in the Acts array.
  */

  /* Initialise hidden unit activation to zero */
  Acts[9+u] = 0.0;

  /* Accumulate weighted sum from inputs */
  for ( i=0; i < 4; ++i )
  Acts[9+u] += *w++ * Acts[5+i];

  /* Subtract threshold */
  Acts[9+u] -= *t++;

  /* Now apply the logistic activation function, 1 / ( 1 + e^-x ).
  * Deal with overflow and underflow
  */
  if ( Acts[9+u] > 100.0 )
  Acts[9+u] = 1.0;
  else if ( Acts[9+u] < -100.0 )
  Acts[9+u] = 0.0;
  else
  Acts[9+u] = 1.0 / ( 1.0 + exp( - Acts[9+u] ) );
  }

  /* Type of output required - selected by outputType parameter */
  /* Post-process output 0, numeric linear scaling */
  double sd = ( Acts[9] - -5.4031700288184421 ) / 6.4841498559077788;

  return (sd);
  }
