/*
  -  BrainTrend1 (,  )
   -  BrainTrend2 ( )

          
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
BrainTrend1.mq4
BrainTrend2.mq4
  (): MetaTrader\experts\indicators\
*/
//++ 
//|                                                   BrainTrend.mq4 |
//|              BrainTrend CODE: Copyright  2006, BrainTrading Inc | 
//|                    Indicator: Copyright  2006, Nikolay Kositsin | 
//|                                            farria@mail.redcom.ru |
//++ 
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 4
//----  
#property indicator_color1 Red 
#property indicator_color2 BlueViolet
#property indicator_color3 Red 
#property indicator_color4 BlueViolet
//----       
#property indicator_maximum 1.1
#property indicator_minimum 0.5
//----   
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 0
#property indicator_width4 0
//----    
#property indicator_level1 0.8
#property indicator_levelcolor Black
#property indicator_levelwidth 3
//----    +
extern int Input_Price_Customs = 0;  // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
extern int Simbol1=110; //      BrainTrend1
extern int Simbol2=110; //      BrainTrend1
extern int Simbol3=108; //      BrainTrend2
extern int Simbol4=108; //      BrainTrend2
//---- +
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
double Ind_Buffer3[];
double Ind_Buffer4[];
//----      
double low,high;
//++  
//| BrainTrend initialization function                               | 
//++  
int init() 
{  
//----     
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexStyle(3,DRAW_ARROW);
//----       
   SetIndexArrow(0,Simbol1);
   SetIndexArrow(1,Simbol2);
   SetIndexArrow(2,Simbol3);
   SetIndexArrow(3,Simbol4);
//---- 2       
   SetIndexBuffer(0,Ind_Buffer1);
   SetIndexBuffer(1,Ind_Buffer2);
   SetIndexBuffer(2,Ind_Buffer3);
   SetIndexBuffer(3,Ind_Buffer4);
//----    (    )     
   IndicatorDigits(0);
//----         
   IndicatorShortName ("BrainTrend"); 
   SetIndexLabel (0, "DownTrend_BrainTrend1"); 
   SetIndexLabel (1, "UpTrend_BrainTrend1");
   SetIndexLabel (2, "DownTrend_BrainTrend2");
   SetIndexLabel (3, "UpTrend_BrainTrend2");
//----  
   return(0);
}
//++  
//| BrainTrend iteration function                                    | 
//++  
int start() 
{ 
//----+        
int reset,MaxBar,limit,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----      
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-1; limit=MaxBar-counted_bars;

//----+     
for(int bar=limit;bar>=0;bar--)
  {
   Ind_Buffer1[bar]=0.0;
   Ind_Buffer2[bar]=0.0;
   Ind_Buffer3[bar]=0.0;
   Ind_Buffer4[bar]=0.0;
   //---
   low =iCustom(NULL,0,"BrainTrend1",Input_Price_Customs,0,bar);
   high=iCustom(NULL,0,"BrainTrend1",Input_Price_Customs,1,bar);
   if (low<high)Ind_Buffer2[bar]=1;else if (low>high)Ind_Buffer1[bar]=1;
   //---
   low =iCustom(NULL,0,"BrainTrend2",Input_Price_Customs,0,bar);
   high=iCustom(NULL,0,"BrainTrend2",Input_Price_Customs,1,bar);
   if (low<high)Ind_Buffer3[bar]=0.6;else if (low>high)Ind_Buffer4[bar]=0.6;
   //---
  }
//----    
return(0);
} 
//+-----------------------------------------------------------------+