//   17.04.2006   
/*
          
PriceSeries.mqh 
  (): MetaTrader\experts\include\
*/
//++ 
//|                                                  BrainTrend1.mq4 |
//|                               Copyright  2005, BrainTrading Inc |
//|                                      http://www.braintrading.com |
//++ 
#property copyright "Copyright  2005, BrainTrading Inc."
#property link      "http://www.braintrading.com"
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Red
#property indicator_color2 Lime
//----    +
extern int Input_Price_Customs = 0;  // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW)
//---- +
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
//---- 
double value2,Range,val1,val2,d,val3;
int    f,p,x1,x2,value11,MEMORY,time2;
//++  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//++ 
//| BrainTrend1 initialization function                              |
//++ 
int init()
  {
//---- indicator 0
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,Ind_Buffer1);
//---- indicator 1  
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexBuffer(1,Ind_Buffer2);
//----           
   string short_name;
   short_name="BrainTrend1";
   IndicatorShortName(short_name);
   SetIndexLabel(0,""+short_name+"_Down");
   SetIndexLabel(1,""+short_name+"_Up"  );
   
   IndicatorDigits(Digits);
   //----        
   PriceSeriesAlert(Input_Price_Customs);
//----  
   f=7; d=2.3; x1 = 53; x2 = 47; value11 = 9;
//----  
   return(0);
  }
//++ 
//| BrainTrend1 iteration function                                   |
//++ 
int start()
  {
//----       
if (Bars < 11)return(0);
//----+        

int limit,MaxBar,Tnew,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,        
MaxBar=Bars-1-10;
//----     ,         
limit=Bars-counted_bars-1; 
if (limit>MaxBar)limit=MaxBar;
Comment("BrainTrading Inc. System 7.0");
Tnew=Time[limit+1];
//+---    +====================+
if (limit<MaxBar)
 if (Tnew==time2)p=MEMORY; 
 else
  {
   if (Tnew>time2)
        Print("  !!! Tnew>time2");
   else Print("  !!! Tnew<time2");
   Print("      !");
   return(-1);  
  }
//+--- +=======================================================+
   bar=limit;
   while(bar>=0)
      {
      //+---    +====+ 
       if (bar==1)
       if(((limit==1)&&(time2==Time[2]))||(limit>1))
        {
         time2=Time[2];
         MEMORY=p;
        }
      //+---+====================================+     
      Range = iATR(NULL,0,f,bar)/d;
      value2 = iStochastic(NULL,0,value11,value11,1,0,0,0,bar);
      val1 = 0.0;
      val2 = 0.0;
      val3 = MathAbs(PriceSeries(Input_Price_Customs,bar) - PriceSeries(Input_Price_Customs,bar+2));
      if (value2 < x2 && val3 > Range) p = 1;
      if (value2 > x1 && val3 > Range) p = 2;
      if (value2 < x2 && (p == 1||p == 0))
         {
         if ( val3 > Range)
            {
             val1 = High[bar];
             val2 = Low [bar];
            }
         }
      if (value2 > x1 && (p == 2||p == 0))
         {
          val2 = High[bar];
          val1 = Low [bar];
         }
      Ind_Buffer1[bar]=val1;
      Ind_Buffer2[bar]=val2;
      bar--;
      } 
//----
   return(0);
  }
//+--------------------------------------------------+

