#property copyright "Andrew Brukhov"
#property link      "pingved@gmail.com"

//+----------------------------------------------------------------------------------------------+
#define INDICATOR_NAME "JMA"
#define CLOSE_PAUSE 5000
#define STATUS_NONE 10

#define ERR_INVALID_PRICE 129
//+----------------------------------------------------------------------------------------------+
extern int jma_fastA = 3;
extern int jma_fastB = 0;
extern int jma_slowA = 20;
extern int jma_slowB = 100;

extern bool UseStopLoss = false;
extern bool UseTakeProfit = false;
extern double StopLoss = 0;
extern double TakeProfit = 0;

extern double DepoUsage = 1.0;
extern int SlipPage = 3;
//+----------------------------------------------------------------------------------------------+
bool FirstStart = true;
bool InitOperation, Operation;
bool OrderSet = false;
int Magic;
//+----------------------------------------------------------------------------------------------+
void init() {
   Magic = GetTickCount();
}//+---------------------------------------------------------------------------------------------+
void start() {
   if(IsTradeAllowed() == false) return;

   if(Volume[0] > 1) {
      return; //       /
   }
   
   if(FirstStart == true) {
      PreInit();
      return;
   }

   //Print("Enter");
   double SL, TP;
   int Res, Status = TradeStatus();
   switch(Status) {
   case OP_BUY: 
      if(OrderSet) CloseOrder();
      if(UseStopLoss) SL = Low[1] - (Point * StopLoss);
      RefreshRates();
      if(UseTakeProfit) TP = Ask + (Point * TakeProfit);
      Res = OrderSend(Symbol(), OP_BUY, LotsOptimized(), Ask, SlipPage, SL, TP, "jma test", Magic, 0, Blue);
      //if(Res == -1) Print("Buy OrderSend error GLE: " + GetLastError());
      OrderSet = true;
      break;
   case OP_SELL:
      if(OrderSet) CloseOrder();
      if(UseStopLoss) SL = High[1] + (Point * StopLoss);
      RefreshRates();
      if(UseTakeProfit) TP = Bid - (Point * TakeProfit);
      Res = OrderSend(Symbol(), OP_SELL, LotsOptimized(), Bid, SlipPage, SL, TP, "jma test", Magic, 0, Red);
      //if(Res == -1) Print("sell OrderSend error GLE: " + GetLastError());
      OrderSet = true;
      break;
   case STATUS_NONE: break;
   }
}//+---------------------------------------------------------------------------------------------+
int TradeStatus() { /* return STATUS_BUY, STATUS_SELL or STATUS_NONE */
   //int Operation = GetInfo();
   //if(Operation == STATUS_NONE) return (STATUS_NONE);
   
   switch(GetInfo()) {
   case OP_BUY:
      //Print("buy");
      Operation = OP_BUY;
      break;
   case OP_SELL:
      //Print("sell");
      Operation = OP_SELL;
      break;
   case STATUS_NONE:
      //Print("none");
      return (STATUS_NONE);
   }
   if(InitOperation == OP_BUY) {
      if(Operation == OP_SELL) { /* forecast trend changed */
         InitOperation = OP_SELL;
         Print("going sell");
         return (OP_SELL);
      }
      //old trend
   } else if(InitOperation == OP_SELL) { /* OPERATION_SELL */
      if(Operation == OP_BUY) { /* forecast trend changed */
         InitOperation = OP_BUY;
         Print("going buy");
         return (OP_BUY);
      }
      //old trend
   }
   return (STATUS_NONE);
}//+---------------------------------------------------------------------------------------------+
void PreInit() { /*    */
   switch(GetInfo()) {
   case OP_BUY:
      Print("first buy");
      InitOperation = OP_BUY;
      FirstStart = false;
      break;
   case OP_SELL:
      Print("first sell");
      InitOperation = OP_SELL;
      FirstStart = false;
      break;
   case STATUS_NONE:
      Print("first none");
      break;
   }
}//+---------------------------------------------------------------------------------------------+
void CloseOrder() {
   int result;
   double ClosePrice;

   for(int i = 0; i < OrdersTotal(); i++) {
      if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES) == false) break;
      if(OrderSymbol() == Symbol() && OrderMagicNumber() == Magic) {
         if(OrderCloseTime() > 0) break;
         if(OrderType() == OP_BUY) {
            ClosePrice = NormalizeDouble(MarketInfo(OrderSymbol(), MODE_BID), Digits);
            result = OrderClose(OrderTicket(), OrderLots(), ClosePrice, SlipPage, Red);
         } else if(OrderType() == OP_SELL) {
            ClosePrice = NormalizeDouble(MarketInfo(OrderSymbol(), MODE_ASK), Digits);
            result = OrderClose(OrderTicket(), OrderLots(), ClosePrice, SlipPage, Blue);
         }
         if(result == false) {
            if(GetLastError() == ERR_INVALID_PRICE) {
               //Print("ERR_INVALID_PRICE");
               Sleep(CLOSE_PAUSE);
            } else break;
         }
      }
   }
}//+------------------------------------------------------------------+
double LotsOptimized() {
   double OurLot;

   double Usage = (AccountFreeMargin() / 100) * DepoUsage;
   Usage *= AccountLeverage();
   OurLot = Usage / MarketInfo(Symbol(), MODE_LOTSIZE);
   OurLot = NormalizeDouble(OurLot, 2);
   double MinLot = MarketInfo(Symbol(), MODE_MINLOT);
   double MaxLot = MarketInfo(Symbol(), MODE_MAXLOT);
   if(OurLot < MinLot) OurLot = MinLot;
   if(OurLot > MaxLot) OurLot = MaxLot;
   //Print("OurLot = " + OurLot);
   return (OurLot);
}//+---------------------------------------------------------------------------------------------+
int GetInfo() {
   double JmaValue1 = iCustom(NULL, 0, INDICATOR_NAME, jma_fastA, 0, 0);
   double JmaValue2 = iCustom(NULL, 0, INDICATOR_NAME, jma_slowA, 0, 0);
   Print("Jma1 " + DoubleToStr(JmaValue1, 8));
   Print("Jma2 " + DoubleToStr(JmaValue2, 8));
   if(JmaValue1 == EMPTY_VALUE) {
      Print("EMPTY_VALUE1");
      return (STATUS_NONE);
   }
   if(JmaValue2 == EMPTY_VALUE) {
      Print("EMPTY_VALUE2");
      return (STATUS_NONE);
   }
   JmaValue1 = NormalizeDouble(JmaValue1, Digits + 1);
   JmaValue2 = NormalizeDouble(JmaValue2, Digits + 1);
   double Result = JmaValue2 - JmaValue1;
   if(Result < 0.0) {
      Print("OP_BUY");
      return (OP_BUY);
   }
   if(Result > 0.0) {
      Print("OP_SELL");
      return (OP_SELL);
   }
   /*
   if(Result == 0.0) {
      return (STATUS_NONE);
   }*/
   Print("None");
   return (STATUS_NONE);
}//+---------------------------------------------------------------------------------------------+