//+------------------------------------------------------------------+
//|                                                        marsi.mq4 |
//|                Copyright  2006, Nick Bilak, beluck[AT]gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Nick Bilak"
#property link      "http://www.mql4.info/"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 1
#property  indicator_color1  Aqua
#property indicator_level1 50
//---- indicator parameters

extern int rtP=7;
extern int Voltrp=9;
extern int Voltype=1;
/*
MODE_SMA 0 Simple moving average, 
MODE_EMA 1 Exponential moving average, 
MODE_SMMA 2 Smoothed moving average, 
MODE_LWMA 3 Linear weighted moving average. 
*/
//---- indicator buffers
double e1[];
double e2[];
double v[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
	IndicatorBuffers(3);
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexEmptyValue(0,0);
   if(
   	!SetIndexBuffer(0,v) ||
   	!SetIndexBuffer(1,e1) ||
   	!SetIndexBuffer(2,e2)
      )
      Print("cannot set indicator buffers!");
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("volatility("+rtP+","+Voltrp+")");
//---- initialization done
   return(0);
   
  }
//+------------------------------------------------------------------+
//| Moving Average of Oscillator                                     |
//+------------------------------------------------------------------+
int start()
  {
   int i,limit;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-Voltrp-1;
   if (counted_bars>0) limit=Bars-counted_bars;
   if (limit<0) limit=0;
   double VCh,HLA;

//---- main loop
   for(i=limit; i>=0; i--) {
  		e1[i]=High[i]-Low[i];
  	}
   for(i=limit; i>=0; i--) {
		e2[i]=iMAOnArray(e1,0,Voltrp,0,Voltype,i);
      VCh=e2[i+rtP];
      HLA=e2[i];
		v[i] = ((HLA - VCh) / VCh) * 100.0;
   }
//---- done
   return(0);
  }
//+------------------------------------------------------------------+

