//+------------------------------------------------------------------+
//|                                                        marsi.mq4 |
//|                Copyright  2006, Nick Bilak, beluck[AT]gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Nick Bilak"
#property link      "http://www.mql4.info/"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 3
#property  indicator_color1  Aqua
#property  indicator_color2  Magenta
#property  indicator_color3  Yellow
#property indicator_level1 25
#property indicator_level2 75
#property indicator_maximum 100
#property indicator_minimum 0
//---- indicator parameters
extern int MA1pr=2;
extern int MA1type=3;
/*
MODE_SMA 0 Simple moving average, 
MODE_EMA 1 Exponential moving average, 
MODE_SMMA 2 Smoothed moving average, 
MODE_LWMA 3 Linear weighted moving average. 
*/
extern int MA2pr=3;
extern int MA2type=1;
extern int RSItpr=13;
//---- indicator buffers
double e1[];
double e2[];
double e3[];
double e4[];
double rs[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
	IndicatorBuffers(5);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexEmptyValue(0,0);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexEmptyValue(1,0);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexEmptyValue(2,0);
   if(
   	!SetIndexBuffer(0,rs) ||
   	!SetIndexBuffer(1,e1) ||
   	!SetIndexBuffer(2,e2)
      )
      Print("cannot set indicator buffers!");
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("rsi2ma("+RSItpr+","+MA1pr+","+MA2pr+")");
//---- initialization done
   return(0);
   
  }
//+------------------------------------------------------------------+
//| Moving Average of Oscillator                                     |
//+------------------------------------------------------------------+
int start()
  {
   int i,limit;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-RSItpr-1;
   if (counted_bars>0) limit=Bars-counted_bars;
   if (limit<0) limit=0;
   double rsm,rsp,rsi_rs;

//---- main loop
   for(i=limit; i>=0; i--) {
  		rs[i]=iRSI(NULL,0,RSItpr,PRICE_CLOSE,i);
  	}
   for(i=limit; i>=0; i--) {
		e1[i]=iMAOnArray(rs,0,MA1pr,0,MA1type,i);
   }
   for(i=limit; i>=0; i--) {
		e2[i]=iMAOnArray(rs,0,MA2pr,0,MA2type,i);
   }
//---- done
   return(0);
  }
//+------------------------------------------------------------------+

