//+------------------------------------------------------------------+
//|                                                 euroform-exp.mq4 |
//|                Copyright  2006, Nick Bilak, beluck[AT]gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Nick Bilak"
#property link      "http://www.mql4.info/"
#include <stdlib.mqh>

extern int expertId=197893;
extern string EAName="euroform";

//extern int TrailStop = 20;

extern string i0="_indicators params_";
extern string i1="__volatility__";
extern int rtP=7;
extern int Voltrp=9;
extern int Voltype=1;
extern double  VolatilityHL=88;

extern string i2="__rsi2ma__";
extern int MA1pr=2;
extern int MA1type=1;
/*
MODE_SMA 0 Simple moving average, 
MODE_EMA 1 Exponential moving average, 
MODE_SMMA 2 Smoothed moving average, 
MODE_LWMA 3 Linear weighted moving average. 
*/
extern int MA2pr=3;
extern int MA2type=1;
extern int RSItpr=33;
extern double  MAofRSIUpHL=75;
extern double  MAofRSIDwnHL=25;


extern string i3="__deltastop__";
extern int     Mode=1; //0 - auto, 1 - manual
extern double  DeltaPrice=10;
extern int     ATRperiod=14;
extern double  ATRratio=2.824;

extern int    ConsecutiveTrades=3;
extern double Lots = 0.1;

extern int    slippage=2;   	//slippage for market order processing
extern int    shift=1;			//shift to current bar for entry 
extern int    OrderTriesNumber=3;

bool buysig,sellsig,closebuy,closesell,cancel,addbuy,addsell; 
int tries;
int last,buys,sells;



//+------------------------------------------------------------------+
//| Calculate open positions                                         |
//+------------------------------------------------------------------+
int CalculateCurrentOrders()  {
   buys=0; sells=0;
   string symbol=Symbol();
//----
   for(int i=0;i<OrdersTotal();i++)
     {
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)==false) continue;
      if(OrderSymbol()==Symbol() && OrderMagicNumber()==expertId)
        {
         if(OrderType()==OP_BUY || OrderType()==OP_BUYSTOP)  buys++;
         if(OrderType()==OP_SELL || OrderType()==OP_SELLSTOP) sells++;
        }
     }
//---- return orders volume
   if(buys>0) return(buys);
   else       return(-sells);
}

//+------------------------------------------------------------------+
//| Check for open order conditions                                  |
//+------------------------------------------------------------------+
void CheckForSignals() {

   	double VolCH=iCustom(NULL,0,"volatility",rtP,Voltrp,Voltype,0,shift);
   	double RSIndex1=iCustom(NULL,0,"rsi2ma",MA1pr,MA1type,MA2pr,MA2type,RSItpr,0,shift);
   	double MAofRSI11=iCustom(NULL,0,"rsi2ma",MA1pr,MA1type,MA2pr,MA2type,RSItpr,1,shift);
   	double MAofRSI21=iCustom(NULL,0,"rsi2ma",MA1pr,MA1type,MA2pr,MA2type,RSItpr,2,shift);
   	double RSIndex2=iCustom(NULL,0,"rsi2ma",MA1pr,MA1type,MA2pr,MA2type,RSItpr,0,shift+1);
   	double MAofRSI12=iCustom(NULL,0,"rsi2ma",MA1pr,MA1type,MA2pr,MA2type,RSItpr,1,shift+1);
   	double MAofRSI22=iCustom(NULL,0,"rsi2ma",MA1pr,MA1type,MA2pr,MA2type,RSItpr,2,shift+1);
   	double TrStop=iCustom(NULL,0,"delta-stop",Mode,DeltaPrice,ATRperiod,ATRratio,0,shift);
      
      double VolHL=VolatilityHL;

      double HL1=MAofRSIUpHL;
      double HL2=MAofRSIDwnHL;
      double HLM=50;

      buysig=false;
      sellsig=false;
      closebuy=false;
      closesell=false;

      //bool Long = cross(MAofRSI,MAofRSI2) and VolCH>VolHL and RSIndex<HLM and RSIndex>HL2 and TrStop<C;
      bool Long = MAofRSI11>MAofRSI21 && MAofRSI12<=MAofRSI22 && VolCH>VolHL && RSIndex1<HLM && RSIndex1>HL2 && TrStop<Close[shift];
      //bool Short = cross(MAofRSI2,MAofRSI) and VolCH>VolHL and RSIndex<HL1 and RSIndex>HLM and TrStop>C;
      bool Short = MAofRSI11<MAofRSI21 && MAofRSI12>=MAofRSI22 && VolCH>VolHL && RSIndex1<HL1 && RSIndex1>HLM && TrStop>Close[shift];
      //bool Long2 = cross(MAofRSI,HLM) and cross(MAofRSI2,HLM) and VolCH>VolHL;
      bool Long2 = MAofRSI11>HLM && MAofRSI12<=HLM && MAofRSI21>HLM && MAofRSI22<=HLM && VolCH>VolHL;
      //bool Short2 = cross(HLM,MAofRSI) and cross(HLM,MAofRSI2) and VolCH>VolHL;
      bool Short2 = MAofRSI11<HLM && MAofRSI12>=HLM && MAofRSI21<HLM && MAofRSI22>=HLM && VolCH>VolHL;
      //bool Long3 = RSIndex-ref(RSIndex,-1)>20;
      bool Long3 = RSIndex1-RSIndex2>20;
      //bool Short3 = ref(RSIndex,-1)-RSIndex>20;
      bool Short3 = RSIndex2-RSIndex1>20;

      buysig = Long || Long2 || Long3;
      sellsig = Short || Short2 || Short3;

      closebuy=sellsig;
      closesell=buysig;
      
}

void CheckForOpen() {

   if (last==Time[0]) return;

   int    res,ord;
   double entry,stop,profit;

   ord=CalculateCurrentOrders();

   if (ord!=0) CheckForClose();

   ord=CalculateCurrentOrders();

//---- buy conditions
   if (buys<ConsecutiveTrades && buysig)  {
		res=OpenAtMarket(OP_BUY,Lots);
		if (res<0) Print("Error opening BUY order : ",ErrorDescription(GetLastError()));
		else last=Time[0];
   }
//---- sell conditions
   if (-sells<ConsecutiveTrades && sellsig)  {
		res=OpenAtMarket(OP_SELL,Lots);
		if (res<=0) Print("Error opening SELL order : ",ErrorDescription(GetLastError()));
		else last=Time[0];
   }
}
  
int OpenAtMarket(int mode,double lot) {
   int    res,tr,col;
   double openprice,sl,tp;
   tries=0;
   while (res<=0 && tries<OrderTriesNumber) {
      tr=0; while (tr<5 && !IsTradeAllowed()) { tr++; Sleep(2000); }
      RefreshRates();
      if (mode==OP_SELL) {
         openprice=Bid; 
         col=Red;
      } else {
         //openprice=nd(Ask);
         openprice=Ask;
         col=Blue;
      }
      res=OrderSend(Symbol(),mode,lot,openprice,slippage,sl,tp,EAName+expertId,expertId,0,col);
      tries++;
   }
   return(res);
}
  
//+------------------------------------------------------------------+
//| Check for close order conditions                                 |
//+------------------------------------------------------------------+
void CheckForClose()  {
	int total;
//----
	total=OrdersTotal();
   for(int i=total;i>=0;i--)
   //for(int i=0;i<total;i++)
     {
      if(!OrderSelect(i,SELECT_BY_POS,MODE_TRADES))  continue;
      if(OrderMagicNumber()!=expertId || OrderSymbol()!=Symbol()) continue;
      //---- check order type 
      if(OrderType()==OP_BUY && closebuy) CloseAtMarket(OrderTicket(),OrderLots());
      if(OrderType()==OP_SELL && closesell) CloseAtMarket(OrderTicket(),OrderLots());
     }

   //int ord=CalculateCurrentOrders();
   //if (ord!=0) CheckForClose();
}

bool CloseAtMarket(int ticket,double lot) {
   bool bres=false; int tr;
   tries=0;
   while (!bres && tries<OrderTriesNumber) {
      tr=0; while (tr<5 && !IsTradeAllowed()) { tr++; Sleep(2000); }
      RefreshRates();
      bres=OrderClose(ticket,lot,OrderClosePrice(),slippage,White);
      if (!bres) Print("Error closing order : ",ErrorDescription(GetLastError()));
      tries++;
   }
}


//+------------------------------------------------------------------+
//| Start function                                                   |
//+------------------------------------------------------------------+
void start()  {

   //---- check for history and trading
   if(Bars<100 || IsTradeAllowed()==false) return;

   //---- check for signals
   CheckForSignals();

   CheckForOpen();
   
}



