//+------------------------------------------------------------------+
//|                                                   delta-stop.mq4 |
//|                Copyright  2006, Nick Bilak, beluck[AT]gmail.com |
//+------------------------------------------------------------------+
#property copyright "Copyright c 2006, Nick Bilak"
#property link      "http://www.mql4.info/"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Red
//---- input parameters
extern int     Mode=0; //0 - auto, 1 - manual
extern double  DeltaPrice=50;
extern int     ATRperiod=14;
extern double  ATRratio=2.824;
double buf[];
double atr[];
double atrs[];

int init()  {
   IndicatorBuffers(3);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,buf);
   SetIndexEmptyValue(1,0);
   SetIndexBuffer(1,atr);
   SetIndexBuffer(2,atrs);
   SetIndexEmptyValue(2,0);
   return(0);
}
int start() {


   int counted_bars=IndicatorCounted();
   int shift,limit,i,k;
   double TrStopLevel,DeltaStop;
   
   if (counted_bars<0) return(-1);
   if (counted_bars>0) counted_bars--;
   limit=Bars-ATRperiod*2-1;
   //if(counted_bars>=ATRperiod) limit=Bars-counted_bars-1;

   if (Mode==0) { 
      for (i=limit+ATRperiod+1;i>=0;i--) {
         atr[i]=iATR(NULL,0,ATRperiod,i);
      }
      for (i=limit;i>=0;i--) {
         atrs[i]=iMAOnArray(atr,0,ATRperiod,0,MODE_SMMA,i);
      }
   }
   else DeltaStop=DeltaPrice;

   for (shift=limit;shift>=0;shift--)   {
      if (Mode==0) DeltaStop=atrs[shift] * ATRratio; else DeltaStop=DeltaPrice*Point;
      if (Close[shift]==buf[shift+1]) buf[shift] = buf[shift+1];
      else if (Close[shift+1]<=buf[shift+1] && Close[shift]<buf[shift+1]) buf[shift]=MathMin(buf[shift+1],Close[shift]+DeltaStop);
      else if (Close[shift+1]>=buf[shift+1] && Close[shift]>buf[shift+1]) buf[shift]=MathMax(buf[shift+1],Close[shift]-DeltaStop);
      else if (Close[shift]>buf[shift+1]) buf[shift]=Close[shift]-DeltaStop;
      else buf[shift]=Close[shift]+DeltaStop;
   }
   return(0);
}


