//+------------------------------------------------------------------+
//|                                         MACD_ColorHist_Alert.mq4 |
//|                                    Copyright  2006, Robert Hill |
//|                                                                  |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2006, Robert Hill"
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 6
#property  indicator_color1 Lime
#property  indicator_color2 Lime
#property  indicator_color3 Red
#property  indicator_color4 Red
#property  indicator_color5 Lime
#property  indicator_color6 Red

#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 1
#property indicator_width4 1
#property indicator_width5 2
#property indicator_width6 2


//---- indicator parameters



extern int FastEMA =12;  //2
extern int SlowEMA =26;  //8
extern int SignalSMA=9;  //6

//extern int  OsmaMultiplier =1;
extern bool ShowHistogram  = true;
extern bool ShowMACDLine   = true;//true
extern bool ShowSignalLine = true;//false

extern bool SoundAlert =true;
extern bool EmailAlert  =false;
extern bool MACDzeroLineCrossAlert   = true;
extern bool MACDSignalLineCrossAlert = true;
extern bool MACDDirectionChangeAlert = false;
extern bool TwoBarsDirChageConfirm   = false;
extern bool ShowAlertStatus = true;
//---- indicator buffers
double     ind_buffer1[];
double     ind_buffer2[];


double HistogramBufferUp[];
double HistogramBufferDown[];

double HistogramBufferUp1[];
double HistogramBufferDown1[];

int flagval11 = 0;
int flagval12 = 0;
int flagval21 = 0;
int flagval22 = 0;
int flagval31 = 0;
int flagval32 = 0;
int flagval41 = 0;
int flagval42 = 0;

//---- variables

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
//   IndicatorBuffers(3);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+1);
   SetIndexBuffer(0,HistogramBufferUp);//lime
   SetIndexBuffer(1,HistogramBufferDown);//red
   SetIndexBuffer(2,HistogramBufferUp1);//green
   SetIndexBuffer(3,HistogramBufferDown1);//maroon
   SetIndexBuffer(4,ind_buffer1);//aqua
   SetIndexBuffer(5,ind_buffer2);//yellow

if(ShowMACDLine)
    {
   SetIndexStyle(4,DRAW_LINE);
   SetIndexDrawBegin(4,SlowEMA);
    }
 else
    {
    SetIndexStyle(4,DRAW_NONE);
    }

if(ShowSignalLine)
    {
   SetIndexStyle(5,DRAW_LINE);
   SetIndexDrawBegin(5,SignalSMA);
    }
 else
    {
    SetIndexStyle(5,DRAW_NONE);
    }
 
 
 if(ShowHistogram)
   {
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexStyle(1,DRAW_HISTOGRAM);
   SetIndexStyle(2,DRAW_HISTOGRAM);
   SetIndexStyle(3,DRAW_HISTOGRAM);
   }
 else
    {
   SetIndexStyle(0,DRAW_NONE);
   SetIndexStyle(1,DRAW_NONE);
   SetIndexStyle(2,DRAW_NONE);
   SetIndexStyle(3,DRAW_NONE);
   }


//   SetIndexDrawBegin(2,SlowEMA + SignalSMA);
//---- name for DataWindow and indicator subwindow label

   if (ShowAlertStatus)
   {
   string _SoundAlert="",_EmailAlert="";
   if(SoundAlert) _SoundAlert="ON";
   if(!SoundAlert)_SoundAlert="OFF";
   if(EmailAlert) _EmailAlert="ON";
   if(!EmailAlert)_EmailAlert="OFF";
   }
   IndicatorShortName("MACDHist_Alert ("+FastEMA+","+SlowEMA+","+SignalSMA+") ");
   
   SetIndexLabel(4,"MACD");
   SetIndexLabel(5,"Signal");
   SetIndexLabel(0,"");
   SetIndexLabel(1,"");
   SetIndexLabel(2,"");
   SetIndexLabel(3,"");
   
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int start()
{
   int limit;
   double temp,temp1;
   
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- macd counted in the 1-st buffer
   for(int i=0; i<limit; i++)
      ind_buffer1[i]=iMA(NULL,0,FastEMA,0,MODE_EMA,PRICE_CLOSE,i)-iMA(NULL,0,SlowEMA,0,MODE_EMA,PRICE_CLOSE,i);
//---- signal line counted in the 2-nd buffer
   for(i=0; i<limit; i++)
      ind_buffer2[i]=iMAOnArray(ind_buffer1,Bars,SignalSMA,0,MODE_SMA,i);

   for(i=0; i<limit; i++)
   {
      HistogramBufferUp[i]    = 0.0;//lime
      HistogramBufferDown[i]  = 0.0;//red
      HistogramBufferUp1[i]   = 0.0;//lime
      HistogramBufferDown1[i] = 0.0;//red
       
//       if (OsmaMultiplier<=0)OsmaMultiplier=1;
//      temp =  ind_buffer1[i]*OsmaMultiplier;
//      temp1 = ind_buffer1[i+1]*OsmaMultiplier;
      
      temp =  ind_buffer1[i];
      temp1 = ind_buffer1[i+1];


    
     if (temp >0) 
       {
          if (temp>temp1)     //>0up
            {       
            HistogramBufferUp[i] = temp;    
            }
            else              //>0dn
            { 
            HistogramBufferUp [i] = 0.0;
            HistogramBufferUp1[i] = temp;   
            }
       }    
      else
       {  
         if (temp>temp1)     //<=0 up
          {       
        HistogramBufferDown[i] = temp; 
          }  
        else                  //<=0 dn
           {
        HistogramBufferDown[i] = 0.0;
        HistogramBufferDown1[i] = temp;  
           }
//---
       }
//-
     if (i == 1)
    {

         if ((ind_buffer1[i] > 0)&&(ind_buffer1[i+1] < 0))
         {
// macd Cross 0 up
         if (flagval11==0)
           {
           flagval11=1;
           flagval12=0;
           flagval32=1;
           if ((SoundAlert)&&(MACDzeroLineCrossAlert)) Alert (Symbol(),"  M",Period(), " MACD crossed 0 Up "); 
                if ((EmailAlert)&&(MACDzeroLineCrossAlert)) SendMail("MACD Crossed Zero Up", "MACD CrossedZero Up, Date="+TimeToStr(CurTime(),TIME_DATE)+" "+TimeHour(CurTime())+":"+TimeMinute(CurTime())+" Symbol="+Symbol()+" Period="+Period());
           }
          }
//
       else if ((ind_buffer1[i]<0 )&&(ind_buffer1[i+1] >0))
        {
//macd Cross 0 down
         if (flagval12==0)
         {
          flagval11=0;
          flagval12=1;
          if ((SoundAlert)&&(MACDzeroLineCrossAlert)) Alert (Symbol(),"  M",Period(), " MACD crossed 0 Down"); 
               if ((EmailAlert)&&(MACDzeroLineCrossAlert)) SendMail("MACD Crossed Zero Down","MACD CrossedZero Down, Date="+TimeToStr(CurTime(),TIME_DATE)+" "+TimeHour(CurTime())+":"+TimeMinute(CurTime())+" Symbol="+Symbol()+" Period="+Period());
         }
        }

//
       else if ((ind_buffer1[i] < ind_buffer2[i])&&(ind_buffer1[i+1] > ind_buffer2[i+1]))
         {
//Macd xSigDn
         if (flagval21==0)
           {
           flagval21=1;
           flagval22=0;
           flagval41=1;
           if ((SoundAlert)&&(MACDSignalLineCrossAlert)) Alert (Symbol(),"  M",Period(), " MACD Signal Line crossed Short"); 
                if ((EmailAlert)&&(MACDSignalLineCrossAlert)) SendMail("MACD xSignalLane & going Down", "MACD xSignalLane & going Down, Date="+TimeToStr(CurTime(),TIME_DATE)+" "+TimeHour(CurTime())+":"+TimeMinute(CurTime())+" Symbol="+Symbol()+" Period="+Period());
           }
         }

       else if ((ind_buffer1[i] > ind_buffer2[i])&&(ind_buffer1[i+1] < ind_buffer2[i+1]))
         {
//Macd xSigUp
         if (flagval22==0)
           {
         flagval21=0;
           flagval22=1;
           if ((SoundAlert)&&(MACDSignalLineCrossAlert)) Alert (Symbol(),"  M",Period(), " MACD Signal Line crossed Long"); 
                if ((EmailAlert)&&(MACDSignalLineCrossAlert)) SendMail("MACD xSignalLane long ", "MACD xSignalLane Long, Date="+TimeToStr(CurTime(),TIME_DATE)+" "+TimeHour(CurTime())+":"+TimeMinute(CurTime())+" Symbol="+Symbol()+" Period="+Period());
           }
         }



// 
       else if  (((ind_buffer1[i]>0)&&(ind_buffer1[i] < ind_buffer1[i+1])&&(ind_buffer1[i+1] < ind_buffer1[i+2])&&(TwoBarsDirChageConfirm))||
                 ((ind_buffer1[i]>0)&&(ind_buffer1[i] < ind_buffer1[i+1])&&(!TwoBarsDirChageConfirm)))
         {
// >0dn
         if (flagval31==0)
           {
           flagval31=1;
           flagval32=0;
           if ((SoundAlert)&&(MACDDirectionChangeAlert)) Alert (Symbol(),"  M",Period(), " MACD Above 0 is Declining...... "); 
                if ((EmailAlert)&&(MACDDirectionChangeAlert)) SendMail("MACD Declining...", "MACD Declining.., Date="+TimeToStr(CurTime(),TIME_DATE)+" "+TimeHour(CurTime())+":"+TimeMinute(CurTime())+" Symbol="+Symbol()+" Period="+Period());
           }
         }

       else if (((ind_buffer1[i]>0)&&(ind_buffer1[i] > ind_buffer1[i+1])&&(ind_buffer1[i+1] > ind_buffer1[i+2])&&(TwoBarsDirChageConfirm))||
                ((ind_buffer1[i]>0)&&(ind_buffer1[i] > ind_buffer1[i+1])&&(!TwoBarsDirChageConfirm)))
         {
// >0up
         if (flagval32==0)
           {
           flagval31=0;
           flagval32=1;
           if ((SoundAlert)&&(MACDDirectionChangeAlert)) Alert (Symbol(),"  M",Period(), " MACD Above 0 is Rising...... "); 
                if ((EmailAlert)&&(MACDDirectionChangeAlert)) SendMail("MACD Rising...", "MACD Rising.., Date="+TimeToStr(CurTime(),TIME_DATE)+" "+TimeHour(CurTime())+":"+TimeMinute(CurTime())+" Symbol="+Symbol()+" Period="+Period());
           }
         }
       else if (((ind_buffer1[i]<=0)&&(ind_buffer1[i] < ind_buffer1[i+1])&&(ind_buffer1[i+1] < ind_buffer1[i+2])&&(TwoBarsDirChageConfirm))||
                ((ind_buffer1[i]<=0)&&(ind_buffer1[i] < ind_buffer1[i+1])&&(!TwoBarsDirChageConfirm)) )
         {
// <0dn
         if (flagval41==0)
           {
           flagval41=1;
           flagval42=0;
           if ((SoundAlert)&&(MACDDirectionChangeAlert)) Alert (Symbol(),"  M",Period(), " MACD Below 0 is Declining...... "); 
                if ((EmailAlert)&&(MACDDirectionChangeAlert)) SendMail("MACD Declining...", "MACD Declining.., Date="+TimeToStr(CurTime(),TIME_DATE)+" "+TimeHour(CurTime())+":"+TimeMinute(CurTime())+" Symbol="+Symbol()+" Period="+Period());
           }
         }
//
       else if  (((ind_buffer1[i]<=0)&&(ind_buffer1[i] > ind_buffer1[i+1])&&(ind_buffer1[i+1] > ind_buffer1[i+2])&&(TwoBarsDirChageConfirm))||
                 ((ind_buffer1[i]<=0)&&(ind_buffer1[i] > ind_buffer1[i+1])&&(!TwoBarsDirChageConfirm)))

         {
// <0up
         if (flagval42==0)
           {
           flagval41=0;
           flagval42=1;
           if ((SoundAlert)&&(MACDDirectionChangeAlert)) Alert (Symbol(),"  M",Period(), " MACD Below 0 is Rising...... "); 
                if ((EmailAlert)&&(MACDDirectionChangeAlert)) SendMail("MACD Rising...", "MACD Rising.., Date="+TimeToStr(CurTime(),TIME_DATE)+" "+TimeHour(CurTime())+":"+TimeMinute(CurTime())+" Symbol="+Symbol()+" Period="+Period());
           }
         }
//

      }
//-

   }
       
//---- done
   return(0);
 }