"use strict";

const signatures = ["MT5", "WFO", "MQL5"];
const header = document.querySelector("meta[name='generator']")?.content;

const copyContent = async(text) =>
{
  const vars = document.querySelector(".vrbls").title.split("; ").filter(Boolean);
  const values = text.split(" ").filter(Boolean);
  if(vars.length != values.length)
  {
    console.log("Arrays mismatch:", vars, values);
    if(vars.length > values.length) return;
    values.length = vars.length; // cut optional status indicators
  }
  let lines = document.querySelector("script[type]")?.innerText.split(/\r?\n/).filter(Boolean);
  if(lines)
  {
    lines.forEach((item, index) => 
    {
      let mod = item.split('|')[0];
      const name = mod.split('=')[0];
      const pos = vars.indexOf(name);
      if(pos != -1) lines[index] = name + "=" + values[pos];
      else lines[index] = mod;
    });
    console.log(lines);
    try
    {
      await navigator.clipboard.writeText(lines.join("\r\n") + "\r\n");
      console.log('Content copied to clipboard');
    }
    catch(err)
    {
      console.error('Failed to copy: ', err);
    }
  }
  else
  {
    console.log("No data due to outdated HTML-report format:", header);
  }
};

if(header && signatures.every(el => header.includes(el)))
{
  console.log("Loading MT5 WFO helper");
  document.querySelectorAll("td:nth-child(21)").forEach(function(e)
  {
    e.addEventListener("click", function()
    {
      copyContent(e.innerText);
    });
  });
}
