package require Tk
package require Mpexpr
#
# мажорные валюты
#
set Majors {
	USD EUR GBP CHF AUD NZD JPY CAD XAU XAG
}
set MSGS {}
#
# тема и расцветки
#
ttk::style theme use alt

ttk::style configure SelectedBuy.TButton -background lightblue
ttk::style map SelectedBuy.TButton -background {{active !active} lightblue}

ttk::style configure SelectedSell.TButton -background pink
ttk::style map SelectedSell.TButton -background {{active !active} pink}

ttk::style configure Big.TButton -borderwidth 3 -font {{Arial black}}
ttk::style configure Price.TLabel -font {{Courier new} 8}
ttk::style configure PriceInc.TLabel -font {{Courier new} 8} -foreground green 
ttk::style configure PriceDec.TLabel -font {{Courier new} 8} -foreground brown 

proc Get { record keys args } {
	if { $args == "*" } {
		set args $keys
	}
	set res {}
	foreach key $keys var $args {
		if { ! [ dict exists $record $key ] } {
			set value {}
		} else {
			set value [ dict get $record $key ]
		}
		lappend res $value
		if { $var != {} } {
			uplevel [ list set $var $value ]
		}
	}
	if { [ llength $keys ] == 1 } {
		return [ lindex $res 0 ]
	}
	return $res
}

#
# панелька
#
oo::class create MajorTrade {

variable Window

variable SelectedBuy
variable SelectedSell
variable Turnover
variable TurnoverMin
variable TurnoverMax
variable TurnoverStep

variable MajorPlan
variable CrossPlan

variable undoTrace

variable accountEquity
variable accountBalance
variable accountMargin
variable accountFreemar
variable accountLeverage

constructor args {
	set undoTrace {}
	set Window .currencyTrade
	set SelectedBuy  [ lindex $::Majors 1 ]
	set SelectedSell [ lindex $::Majors 0 ]
	set Turnover 100000
	set TurnoverMin 0.1
	set TurnoverMax 5000000
	set TurnoverStep 0.1
	set accountEquity 0
	set accountBalance 0
	set accountMargin 0
	set accountFreemar 0
	set accountLeverage 0
	set MajorPlan {}
	set CrossPlan {}

	my LoadConfig

	WalletInfo USD { balance equity margin freemar leverage } accountBalance accountEquity accountMargin accountFreemar accountLeverage
	my Layout
	my BindModel
	my TradePlan
}

destructor {
	my SaveConfig
	foreach command $undoTrace {
		try {
			{*}$command
		} on error err {
			puts "undoTrace error $err"
		}
	}
}

method LoadConfig {} {
	try {
		set config [ file join $::MetaTrader(DataDir) MQL5 Files MajorTrade.config ]
		set f [ open $config "r" ]
		set buy [ gets $f ]
		set sell [ gets $f ]
		set turnover [ gets $f ]
		close $f
		if { $buy in $::Majors && $sell in $::Majors } {
			set SelectedBuy $buy
			set SelectedSell $sell
			set Turnover $turnover
		}
	} on error err {
		puts "LoadConfig error $err"
	}
}

method SaveConfig {} {
	try {
		set config [ file join $::MetaTrader(DataDir) MQL5 Files MajorTrade.config ]
		set f [ open $config "w" ]
		puts $f [ my SelectedSell ]
		puts $f [ my SelectedBuy ]
		puts $f [ my Turnover ]
		close $f
	} on error err {
		puts "SaveConfig error $err"
	}
}

method Layout {} {
	set w [ ttk::frame $Window ]
	set top [ winfo toplevel $Window ]
	wm protocol $top WM_DELETE_WINDOW [ list [ self ] OnDeleteWindow ]
	# основые фреймы
	ttk::frame $w.sell
	ttk::frame $w.buy 
	ttk::frame $w.account
	ttk::frame $w.invest
	ttk::frame $w.cross -relief raised -borderwidth 3
	ttk::frame $w.majors -relief raised -borderwidth 3
	grid $w.sell -row 0 -column 0 -columnspan 2 -sticky "nsew"
	grid $w.buy -row 1 -column 0 -columnspan 2 -sticky "nsew"
	grid $w.account -row 2 -column 0 -columnspan 2 -sticky "nsew"
	grid $w.invest -row 3 -column 0 -columnspan 2 -sticky "nsew"
	grid $w.cross -row 4 -column 0 -sticky "nsew"
	grid $w.majors -row 4 -column 1 -sticky "nsew"
	grid columnconfigure $w 0 -weight 1 -uniform same
	grid columnconfigure $w 1 -weight 1 -uniform same
	set column 0
	# кнопки Buy/Sell с валютами
	foreach name $::Majors {
		set lcname [string tolower $name]
		
		ttk::frame $w.buy.$lcname
		ttk::button $w.buy.$lcname.select -text $name -command [ list [ self ] SelectBuy $name ]
		ttk::label  $w.buy.$lcname.price -text 1.0 -style "Price.TLabel" -anchor center
		pack $w.buy.$lcname.select -side top -fill both -expand yes
		pack $w.buy.$lcname.price -side top -fill x -expand yes
		
		ttk::frame $w.sell.$lcname
		ttk::label  $w.sell.$lcname.price -text 1.0 -style "Price.TLabel" -anchor center
		ttk::button $w.sell.$lcname.select -text $name -command [ list [ self ] SelectSell $name ]
		pack $w.sell.$lcname.price -side top -fill x -expand yes
		pack $w.sell.$lcname.select -side top -fill both -expand yes
		
		grid $w.buy.$lcname -row 0 -column $column 
		grid $w.sell.$lcname -row 0 -column $column 
		grid columnconfigure $w.buy $column -weight 1 -uniform same
		grid columnconfigure $w.sell $column -weight 1 -uniform same
		if { $name == $SelectedBuy } {
			$w.buy.$lcname.select configure -style "SelectedBuy.TButton"
		}
		if { $name == $SelectedSell } {
			$w.sell.$lcname.select configure -style "SelectedSell.TButton"
		}
		incr column
	}
	# аккаунт (баланс, экви и проч.)
	ttk::frame $w.account.data
	grid $w.account.data -column 1 -sticky nsew
	grid columnconfigure $w.account 0 -weight 1 -uniform same
	grid columnconfigure $w.account 2 -weight 1 -uniform same
	ttk::label $w.account.data.balanceLabel -text "Balance:"
	ttk::label $w.account.data.balance -textvariable [ my varname accountBalance ]
	ttk::label $w.account.data.equityLabel -text "Equity:"
	ttk::label $w.account.data.equity -textvariable [ my varname accountEquity ]
	ttk::label $w.account.data.freemarLabel -text "FreeMar:"
	ttk::label $w.account.data.freemar -textvariable [ my varname accountFreemar ]
	grid $w.account.data.balanceLabel -row 0 -column 0 -sticky "nse"
	grid $w.account.data.balance	  -row 0 -column 1 -sticky "nsw"
	grid $w.account.data.equityLabel  -row 0 -column 2 -sticky "nse"
	grid $w.account.data.equity	      -row 0 -column 3 -sticky "nsw"
	grid $w.account.data.freemarLabel -row 0 -column 4 -sticky "nse"
	grid $w.account.data.freemar	  -row 0 -column 5 -sticky "nsw"
	grid columnconfigure $w.account.data 0 -weight 1 -uniform same
	grid columnconfigure $w.account.data 1 -weight 1 -uniform same
	grid columnconfigure $w.account.data 2 -weight 1 -uniform same
	grid columnconfigure $w.account.data 3 -weight 1 -uniform same
	grid columnconfigure $w.account.data 4 -weight 1 -uniform same
	grid columnconfigure $w.account.data 5 -weight 1 -uniform same
	
	# оборот (инвестиция)
	ttk::label $w.invest.margin -text "Turnover:"
	ttk::spinbox $w.invest.moneys -from $TurnoverMin -to $TurnoverMax -increment $TurnoverStep -command [ list [ self ] TradePlan ]
	$w.invest.moneys set [ expr $Turnover / 1000 ]
	ttk::label $w.invest.xusd -text "* 1000 usd"
	grid $w.invest.margin -row 0 -column 1
	grid $w.invest.moneys -row 0 -column 2
	grid $w.invest.xusd -row 0 -column 3 
	grid columnconfigure $w.invest 0 -weight 1 -uniform same
	grid columnconfigure $w.invest 4 -weight 1 -uniform same
	# торговые варианты
	# через кросс
	text $w.cross.plan -width 20 -height 5
	$w.cross.plan tag configure buy -foreground blue -font bold
	$w.cross.plan tag configure sell -foreground brown -font bold
	$w.cross.plan tag configure center -justify center
	ttk::button $w.cross.trade -text "trade crosses" -style "Big.TButton" -command [ list [ self ] OnTradeCross ]
	grid $w.cross.plan -row 0 -column 0 -sticky "nsew"
	grid $w.cross.trade -row 1 -column 0 -sticky "nsew"
	grid columnconfigure $w.cross 0 -weight 1
	# парно через мажоры
	text $w.majors.plan -width 20 -height 5
	$w.majors.plan tag configure buy -foreground blue -font bold
	$w.majors.plan tag configure sell -foreground brown -font bold
	$w.majors.plan tag configure center -justify center
	ttk::button $w.majors.trade -text "trade majors" -style "Big.TButton" -command [ list [ self ] OnTradeMajors ]
	grid $w.majors.plan -row 0 -column 0 -sticky "nsew"
	grid $w.majors.trade -row 1 -column 0 -sticky "nsew"
	grid columnconfigure $w.majors 0 -weight 1
	my TradePlan
	wm deiconify $top
	focus $top
	raise $top
#	grab set -global $top
}

method Window {} {
	set Window
}
method OnDeleteWindow {} {
	lappend ::MSGS [ list [ clock seconds ] destroy ]
}

method SelectBuy { name } {
	if { $name ni $::Majors } {
		return
	}
	if { $name == $SelectedBuy } {
		return
	}
	if { $name == $SelectedSell } {
		$Window.sell.[string tolower $SelectedSell ].select configure -style TButton
		$Window.buy.[string tolower $SelectedBuy  ].select  configure -style TButton
		set SelectedSell $SelectedBuy
		set SelectedBuy $name
		$Window.sell.[string tolower $SelectedSell ].select configure -style SelectedSell.TButton
		$Window.buy.[string tolower $SelectedBuy ].select   configure -style SelectedBuy.TButton
	} else {
		$Window.buy.[string tolower $SelectedBuy ].select configure -style TButton 
		set SelectedBuy $name
		$Window.buy.[string tolower $SelectedBuy ].select configure -style SelectedBuy.TButton
	}
	my TradePlan
}

method SelectSell { name } {
	if { $name ni $::Majors } {
		return
	}
	if { $name == $SelectedSell } {
		return
	}
	if { $name == $SelectedBuy } {
		$Window.sell.[string tolower $SelectedSell ].select configure -style TButton
		$Window.buy.[string tolower $SelectedBuy  ].select configure -style TButton
		set SelectedBuy $SelectedSell
		set SelectedSell $name
		$Window.sell.[string tolower $SelectedSell ].select configure -style SelectedSell.TButton
		$Window.buy.[string tolower $SelectedBuy ].select configure -style SelectedBuy.TButton
	} else {
		$Window.sell.[string tolower $SelectedSell ].select configure -style TButton 
		set SelectedSell $name
		$Window.sell.[string tolower $SelectedSell ].select configure -style SelectedSell.TButton
	}
	my TradePlan
}
method ShowPlan { plan text } {
	$text configure -state normal
	$text delete 0.1 end
	foreach record $plan {
		if { $record == {} } {
			continue
		}
		Get $record {turnover symbol lots op price} *
		if { $lots == 0 || $price == 0 } {
			continue
		}
		if { $op == "buy" } {
			set tag "buy"
		} else {
			set tag "sell"
		}
		$text insert end [ string totitle $op ] [ list $tag center ]
		$text insert end " "
		$text insert end $lots
		$text insert end " "
		$text insert end $symbol $tag
		if { $price != {} } {
			$text insert end " * " 
			$text insert end $price
		}
		$text insert end "\n"
	}
	$text configure -state disabled
}
method TradePlan {} {
	if { $SelectedBuy == "" || $SelectedSell == "" } {
		continue
	}
	set Turnover [ my Turnover ]
	set CrossPlan [ list [ my MakePlan $SelectedBuy $SelectedSell $Turnover ] ]
	set MajorPlan [ list [ my MakePlan $SelectedBuy "USD" $Turnover ] [ my MakePlan "USD" $SelectedSell $Turnover ] ] 
	my ShowPlan $CrossPlan $Window.cross.plan
	my ShowPlan $MajorPlan $Window.majors.plan
}
method SelectedBuy {} {
	return $SelectedBuy
}
method SelectedSell {} {
	return $SelectedSell
}
method Turnover {} {
	set turn [ $Window.invest.moneys get ]
	expr { $turn * 1000 }
}
method FindSymbol { one two } {
	foreach name [ array names ::SYMBOLS ] {
		SymbolInfo $name { name base quote } *
		if { ( $base == $one && $quote == $two ) || ( $base == $two && $quote == $one ) } {
			return $name
		}
	}
	return ""
}
method VolumeByTurnover { symbol turnover {op "buy"} } {
	SymbolInfo $symbol { base quote bid ask } *
	if { $base == "USD" } {
		return $turnover
	} elseif { $quote == "USD" } {
		if { $ask == 0 } {
			return 0
		}
		set volume [ mpexpr { $turnover / $ask } ]
		return $volume
	}
	set major [ my FindSymbol $base "USD" ]
	if { $major != "" } {
		SymbolInfo $major { base quote bid ask } *
		if { $quote == "USD" } {
			if { $ask == 0 } {
				set price 0
			} else {
				set price [ mpexpr 1.0 / $ask ]
			}
		} else {
			set price $bid
		}
	} else {
		set major [ my FindSymbol $quote "USD" ]
		if { $major == "" } {
			set price 0
		} else {
			SymbolInfo $major { base quote bid ask } *
			if { $quote == "USD" } {
				if { $bid == 0 } {
					set price 0
				} else {
					set price [ mpexpr 1.0 / $bid ]
				}
			} else {
				set price $ask
			}
		}
	}
	set volume [ expr { $turnover * $price } ]
	return $volume
}
method LotsByVolume { symbol volume } {
	SymbolInfo $symbol lotSize *
	set lots [ mpexpr {$volume / $lotSize} ]
	return [ my RoundLots $symbol $lots ]
}
method RoundLots { symbol lots } {
	SymbolInfo $symbol { minLot maxLot lotStep } *
	if { $lots < $minLot } {
		return $minLot
	}
	set lots [ mpexpr { $minLot + $lotStep * round(($lots-$minLot)/$lotStep) } ]
	if { $lots > $maxLot } {
		return $maxLot;
	}
	return $lots
}
method MakePlan { buy sell turnover } {
	if { $buy == $sell } return {}
	set symbol [ my FindSymbol $buy $sell ]
	if { $symbol == {} } {
		return {}
	}
	SymbolInfo $symbol { base quote bid ask digits } *
	if { $buy == $base } {
		set op "buy"
		set price [ format "%.*f" $digits $ask ]
	} else {
		set op "sell"
		set price [ format "%.*f" $digits $bid ]
	}
	set volume [ my VolumeByTurnover $symbol $turnover $op ]
	set lots   [ my LotsByVolume $symbol $volume ]
	return [ list symbol $symbol lots $lots	op $op price $price ]
}

method BindModel {} {
	if { [ info exists ::ASSETS ] } {
		foreach name $::Majors {
			if { ! [ info exists ::ASSETS($name) ] } {
				continue
			}
			trace add variable ::ASSETS($name) {write unset} [ list [ self ] OnAsset $name ]
			lappend undoTrace [ list trace remove variable ::ASSETS($name) {write unset} {} ]
			if { [ dict exists $::ASSETS($name) symbol ] } {
				set symbol [ dict get $::ASSETS($name) symbol ]
				trace add variable ::SYMBOLS($symbol) { write unset } [ list [ self ] OnSymbol $name $symbol ]
				lappend undoTrace [ list trace remove variable ::SYMBOLS($symbol) {write unset} {} ]
			}
		}
	}
	trace add variable ::WALLETS(USD) { write unset } [ list [ self ] OnWallet USD ]
	trace add variable ::WALLETS("USD") { write unset } [ list [ self ] OnWallet USD ]
	lappend undoTrace [ list trace add variable ::WALLETS(USD) { write unset } [ list [ self ] OnWallet USD ] ]
}
method OnAsset { asset arr key op } {
}
method OnSymbol { asset symbol arr key op } {
	try {
		SymbolInfo $symbol {base quote bid ask digits} *
		if { $base == "USD" && $quote in $::Majors } {
			set lcname [ string tolower $quote ]
			set askLabel $Window.buy.$lcname.price
			set bidLabel $Window.sell.$lcname.price
			set oldAsk [ $askLabel cget -text ]
			set oldBid [ $bidLabel cget -text ]
			if { $bid>100 || $ask>100 } {
				set digits 5
			}
			set newAsk [ format "%.*f" [ expr {$digits+1} ] [ expr 1.0/$bid ] ]
			set newBid [ format "%.*f" [ expr {$digits+1} ] [ expr 1.0/$ask ] ]
			if { $newAsk != $oldAsk } {
				if { $newAsk > $oldAsk } {
					$askLabel configure -text $newAsk -style PriceInc.TLabel
				} else {
					$askLabel configure -text $newAsk -style PriceDec.TLabel
				}
			}
			if { $newBid != $oldBid } {
				if { $newBid > $oldBid } {
					$bidLabel configure -text $newBid -style PriceInc.TLabel
				} else {
					$bidLabel configure -text $newBid -style PriceDec.TLabel
				}
			}
		} elseif { $quote == "USD" && $base in $::Majors } {
			set lcname [ string tolower $base ]
			set askLabel $Window.buy.$lcname.price
			set bidLabel $Window.sell.$lcname.price
			set oldAsk [ $askLabel cget -text ]
			set oldBid [ $bidLabel cget -text ]
			set newAsk [ format "%.*f" $digits $ask ]
			set newBid [ format "%.*f" $digits $bid ]
			if { $newAsk != $oldAsk } {
				if { $newAsk > $oldAsk } {
					$askLabel configure -text $newAsk -style PriceInc.TLabel
				} else {
					$askLabel configure -text $newAsk -style PriceDec.TLabel
				}
			}
			if { $newBid != $oldBid } {
				if { $newBid > $oldBid } {
					$bidLabel configure -text $newBid -style PriceInc.TLabel
				} else {
					$bidLabel configure -text $newBid -style PriceDec.TLabel
				}
			}
		}
		if { ( $base == $SelectedBuy && $quote == $SelectedSell ) ||
			( $base == "USD" && $quote == $SelectedSell ) ||
			( $base == $SelectedBuy && $quote == "USD" ) ||
			( $base == $SelectedSell && $quote == $SelectedBuy ) ||
			( $base == "USD" && $quote == $SelectedBuy ) ||
			( $base == $SelectedSell && $quote == $SelectedBuy) } {
			my TradePlan
		}
	} on error err {
		puts "error $err"
	}
}
method OnWallet { asset  arr key op } {
	if { $asset!="USD" || ! [ info exists ::WALLETS($asset) ] } {
		return
	}
	WalletInfo USD { balance equity margin freemar leverage } accountBalance accountEquity accountMargin accountFreemar accountLeverage
}
method OnTradeCross {} {
	if { [ llength $CrossPlan ] > 0 && [ llength [ lindex $CrossPlan 0 ] ] > 0 } {
		my DoTrade $CrossPlan 
	}
}
method OnTradeMajors {} {
	if { [ llength $MajorPlan ] > 0 && ( [ llength [ lindex $MajorPlan 0 ] ] > 0 || [ llength [ lindex $MajorPlan 1 ] ] > 0 ) } {
		my DoTrade $MajorPlan 
	}
}
method DoTrade { plan } {
	foreach record $plan {
		Get $record { op symbol lots price } *
		lappend ::MSGS [ list [ clock seconds ] $op $symbol $lots $price ]
	}
}
export Window SelectBuy SelectSell OnAsset OnSymbol OnWallet OnTradeCross OnTradeMajors TradePlan SelectedBuy SelectedSell OnDeleteWindow
};

proc GetInfo { data keys args } {
	set res {}
	if { $args == "*" } {
		set args $keys
	}
	foreach key $keys var $args {
		if { ! [ dict exists $data $key ] } {
			set value ""
		} else {
			set value [ dict get $data $key ]
		}
		lappend res $value
		if { $var != {} } {
			uplevel [ list set $var $value ]
		}
	}
	if { [ llength $keys ] == 1 } {
		return [ lindex $res 0 ]
	} else {
		return $res
	}
}
proc SymbolInfo { name keys args } {
	tailcall GetInfo $::SYMBOLS($name) $keys {*}$args
}
proc AssetInfo { name keys args } {
	tailcall GetInfo $::ASSETS($name) $keys {*}$args
}
proc WalletInfo { name keys args } {
	tailcall GetInfo $::WALLETS($name) $keys {*}$args
}

if { [ info exists argv0 ] && $argv0 != {} } {
	array set SYMBOLS {}
	array set ASSETS {}
	array set ASSETS {
		USD {}
		EUR {symbol EURUSD bid 1.23456 ask 1.23458}
	}
	array set SYMBOLS {
		EURUSD {base EUR quote USD digits 5 point 0.00001 bid 0.12345 ask 0.654321}
	}
	set ct [ MajorTrade new ]
	
	pack [ $ct Window ]
	update
	dict set SYMBOLS(EURUSD) bid 1.20001
	tkwait window .
}
