"use strict";

const regex = /(?<keyword>\bbreak\b|\bcase\b|\bclass\b|\bconst\b|\bcontinue\b|\bdefault\b|\bdelete\b|\bdo\b|\bdynamic_cast\b|\belse\b|\bexport\b|\bextern\b|\bfalse\b|\bfinal\b|\bfor\b|\bif\b|\bimport\b|\binline\b|\binput\b|\binterface\b|\bnew\b|\bNULL\b|\boperator\b|\boverride\b|\bprivate\b|\bprotected\b|\bpublic\b|\breturn\b|\bsinput\b|\bsizeof\b|\bstatic\b|\bstatic_cast\b|\bstruct\b|\bswitch\b|\btemplate\b|\bthis\b|\btrue\b|\btypedef\b|\btypename\b|\bunion\b|\bvirtual\b|\bwhile\b|\bchar\b|\bshort\b|\bint\b|\blong\b|\buchar\b|\bushort\b|\buint\b|\bulong\b|\bbool\b|\bstring\b|\bdouble\b|\bfloat\b|\bcolor\b|\bdatetime\b|\benum\b|\bunsigned\b|\bvoid\b|#\bdefine\b|#\belse\b|#\bendif\b|#\bifdef\b|#\bifndef\b|#\bimport\b|#\binclude\b|#\bproperty\b|#\bresource\b|#\bundef\b)/g;

window.addEventListener("DOMContentLoaded", async function()
{
   const targetNode = document.getElementsByClassName("chat-page")[0];
   // variants non-working somehow
   // document.getElementById("chatContainer"); // document.getElementsByClassName("chat-comments-list")[0];
   console.log("chat found:", targetNode);
   if(targetNode)
   {
      const callback = (mutationList, observer) =>
      {
         for(const mutation of mutationList)
         {
            for(const n of mutation.addedNodes)
            {
               if(n.className == "chat-message__text")
               {
                  if(n.innerHTML.match(/```mql5(?<main>[\s\S]*?)```/)) // match markdown ```code``` (mql5 specific with syntax highlighting)
                  {
                     console.log(n.innerHTML);
                     n.innerHTML = n.innerHTML.replace(/```(?:\n|<br>)?(?<main>[\s\S]*?)```/g, (match, block) =>
                     {
                        const modifiedBlock = block.replace(regex, "<span class='keyword'>$<keyword></span>");
                        return "<pre class='code'>" + modifiedBlock + "</pre>";
                     });
                  }
                  else if(n.innerHTML.match(/```(?<main>[\s\S]*?)```/)) // match markdown ```code``` (general case)
                  {
                     console.log(n.innerHTML);
                     n.innerHTML = n.innerHTML.replace(/```(\n|<br>)?(?<main>[\s\S]*?)```/g, "<pre class='code'>$<main></pre>");
                  }
                  else if(n.innerHTML.match(/(?<main>(?:<br>\s+.*)+)<br>/))
                  {
                     console.log(n.innerHTML);
                     n.innerHTML = n.innerHTML.replaceAll(/(?:<br>)(?<main>(?:\s+.*?(?:<br>|$))+)/g, "<pre class='code'>$<main></pre>");
                  }
               }
            }
         }
      };

      const observer = new MutationObserver(callback);
      observer.observe(targetNode, { childList: true, subtree: true });
      console.log("observing...");
   }
});
