//--------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------
  #property       copyright "Copyright 2023.11.09, Evgeny Shevtsov"
  #property       link      "https://www.mql5.com/en/users/eshv/seller"
  #property       version   "3.2"
//----------------
  #property       strict
//--------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------
  enum            hstload {FromSpecifiedTime,InMonths,InWeeks,InDays,InHours};
  input           hstload HistoryLoadMode=3;
//--------
  input datetime  HistoryStartTime=1672531200;
  input uint      HistoryMonths=0;
  input uint      HistoryWeeks=0;
  input uint      HistoryDays=0;
  input uint      HistoryHours=0;
//--------
  input string    M01="---------------- Main settings ----------------";
//--------
  enum            mode {Chart,BuyAndSell,DeltaAsColumnsUpOnly,DeltaAsColumnsUpAndDown,DeltaAsCandlesUpOnly,DeltaAsCandlesUpAndDown,CumulativeDelta};
  input           mode Mode=0;
//--------
  enum            calc {ByEventsOfDeals,BySizesOfDeals,ByEventsOfAllTicks,BySizesOfAllTicks,ByEventsOfActiveTicks,BySizesOfActiveTicks};
  input           calc Calculation=3;
//--------
  enum            vpoint {Limit,Market};
  input           vpoint ViewPoint=1;
//--------
  enum            chart {Current,
                         MN,W1,D1,
                         H12,H8,H6,H4,H3,H2,H1,
                         M30,M20,M15,M12,M10,M6,M5,M4,M3,M2,M1,
                         S30,S20,S15,S10,S5};
  input           chart Timeframe=0;
//--------
  input ulong     ExceedanceValue=0;
//--------
  input int       RecalculationTiming=-1;
//--------
  input string    M02="---------------- Cumulative settings ----------------";
//--------
  enum            cdreset {Disable,Monthly,Weekly,Daily,Hourly};
  input           cdreset CumulativeReset=0;
//--------
  input int       CumulativePeriod=0;
//--------
        string    M03="---------------- Rectangle settings ----------------";
        color     RectangleColor=clrNONE;
        color     RectangleFontColor=clrNONE;
        color     RectangleNeutralColor=clrDimGray;
        color     RectanglePositiveColor=clrSteelBlue;
        color     RectangleNegativeColor=clrIndianRed;
        string    RectanglePrefix="Rectangle";
        bool      RectangleAutoPrice=true;
        int       RectangleFontSize=7;
//--------
  input string    M04="---------------- Levels settings ----------------";
//--------
  enum            lvls {Auto,Manual,Disable};
  input           lvls Levels=0;
  input color     LevelsColor=clrGray;
//--------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------
  int             bars = 10;                   // quantity of bars
//--------
  int             buffBuyNumber   =  0;        // number of buffer of Buy values
  int             buffSellNumber  =  1;        // number of buffer of Sell values
  
  int             buffOpenNumber  =  7;        // number of buffer of Open values
  int             buffHighNumber  =  8;        // number of buffer of High values
  int             buffLowNumber   =  9;        // number of buffer of Low values
  int             buffCloseNumber = 10;        // number of buffer of Close values
//--------
  double          buffBuyValues[];             // array for Buy values
  double          buffSellValues[];            // array for Sell values
  
  double          buffOpenValues[];            // array for Open values
  double          buffHighValues[];            // array for High values
  double          buffLowValues[];             // array for Low values
  double          buffCloseValues[];           // array for Close values
//----------------
  int             digits;                      // digits
//--------
  int             IND;                         // handle
//--------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------
  void OnInit()
  {
//---- digits of Mode
   if (Mode==0) digits=Digits();
   if (Mode==1 || Mode==2 || Mode==3 || Mode==4 || Mode==5) digits=2;
//---- init arrays
   ArraySetAsSeries(buffBuyValues,true);  ArrayResize(buffBuyValues,bars);
   ArraySetAsSeries(buffSellValues,true); ArrayResize(buffSellValues,bars);
   
   ArraySetAsSeries(buffOpenValues,true);  ArrayResize(buffOpenValues,bars);
   ArraySetAsSeries(buffHighValues,true);  ArrayResize(buffHighValues,bars);
   ArraySetAsSeries(buffLowValues,true);   ArrayResize(buffLowValues,bars);
   ArraySetAsSeries(buffCloseValues,true); ArrayResize(buffCloseValues,bars);
//--------
   IND = iCustom(
                 Symbol(),
                 PERIOD_CURRENT,
                 "Market\\Time And Sales Delta",
                 //"tas-3.2",
                 
                 HistoryLoadMode,
                 HistoryStartTime,
                 HistoryMonths,
                 HistoryWeeks,
                 HistoryDays,
                 HistoryHours,
                 "",
                 
                 Mode,
                 Calculation,
                 ViewPoint,
                 Timeframe,
                 ExceedanceValue,
                 RecalculationTiming, // the value does not matter, but the figure should be negative, as a sign that the indicator is called from the outside
                 "",
                 
                 CumulativeReset,
                 CumulativePeriod,
                 "",
                 
                 RectangleColor,
                 RectangleFontColor,
                 RectangleNeutralColor,
                 RectanglePositiveColor,
                 RectangleNegativeColor,
                 RectanglePrefix,
                 RectangleAutoPrice,
                 RectangleFontSize,
                 "",
                 
                 Levels,
                 LevelsColor
                );
//--------
   return;
  }
//--------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------
  void OnTick() // since the indicator is "heavy", it is advisable to make a calling not on every tick, but to apply some thinning (for example, every ten ticks)
  {
   if (Mode==1 || Mode==2 || Mode==3)
   {
    if (CopyBuffer(IND,buffBuyNumber ,0,bars,buffBuyValues )==bars) Print("Buy value = " +DoubleToString(buffBuyValues[1],digits));  // load Buy values
    if (CopyBuffer(IND,buffSellNumber,0,bars,buffSellValues)==bars) Print("Sell value = "+DoubleToString(buffSellValues[1],digits)); // load Sell values
   }
//--------
   if (Mode==0 || Mode==4 || Mode==5)
   {
    if (CopyBuffer(IND,buffOpenNumber ,0,bars,buffOpenValues )==bars) Print("Open value = " +DoubleToString(buffOpenValues[1],digits));  // load Open values
    if (CopyBuffer(IND,buffHighNumber ,0,bars,buffHighValues )==bars) Print("High value = " +DoubleToString(buffHighValues[1],digits));  // load High values
    if (CopyBuffer(IND,buffLowNumber  ,0,bars,buffLowValues  )==bars) Print("Low value = "  +DoubleToString(buffLowValues[1],digits));   // load Low values
    if (CopyBuffer(IND,buffCloseNumber,0,bars,buffCloseValues)==bars) Print("Close value = "+DoubleToString(buffCloseValues[1],digits)); // load Close values
   }
//--------
   return;
  }
//--------------------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------------------
