//+------------------------------------------------------------------+
//|                                                  EaseXMLNode.mqh |
//|                                  Copyright 2013, Paul van Hemmen |
//|                                          http://www.vanhemmen.de |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, Paul van Hemmen"
#property link      "http://www.vanhemmen.de"
#property version   "1.00"

//+------------------------------------------------------------------+
//| Includes                                                         |
//+------------------------------------------------------------------+
#include <Object.mqh>
#include <Arrays\ArrayObj.mqh>
#include <EasyXML\EasyXmlAttribute.mqh>
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CEasyXmlNode : public CObject
  {
private:
   CArrayObj        *ChildNodes;
   CArrayObj        *AttributeNodes;
   CEasyXmlNode     *ParentNode;
   string            sName;
   string            sValue;

public:
   void              setName(string pName);
   void              setValue(string pValue);
   void              setAttribute(string pName,string pValue);

   string            getName(void);
   string            getValue(void);
   string            getAttribute(string pName);

   CEasyXmlNode     *createChild(CEasyXmlNode *pChildNode);
   CEasyXmlNode     *createSibling(CEasyXmlNode *pSiblingNode);

   CEasyXmlNode     *Parent(void);
   void              Parent(CEasyXmlNode *pParentNode);

   CArrayObj        *Children(void);
   CArrayObj        *Attributes(void);
   CEasyXmlNode     *LastChild(void);
   CEasyXmlNode     *FirstChild(void);

                     CEasyXmlNode();
                    ~CEasyXmlNode();
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
CEasyXmlNode::CEasyXmlNode()
  {
   ChildNodes=new CArrayObj;
   AttributeNodes=new CArrayObj;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

CEasyXmlNode::~CEasyXmlNode()
  {
   if(CheckPointer(ChildNodes) == POINTER_DYNAMIC) 
     {
      for(int i = 0; i < ChildNodes.Total(); i++) 
        {
         ChildNodes.Delete(i);
        }
      delete ChildNodes;
     }
   if(CheckPointer(AttributeNodes) == POINTER_DYNAMIC) 
     {
      for(int i = 0; i < AttributeNodes.Total(); i++) 
        {
         AttributeNodes.Delete(i);
        }
      delete AttributeNodes;
     }
  }
//+------------------------------------------------------------------+
//| set tag name                                                     |
//+------------------------------------------------------------------+
void CEasyXmlNode::setName(string pName)
  {
   sName=pName;
  }
//+------------------------------------------------------------------+
//| set tag content value                                            |
//+------------------------------------------------------------------+
void CEasyXmlNode::setValue(string pValue)
  {
   sValue=pValue;
  }
//+------------------------------------------------------------------+
//| set attribute                                                    |
//+------------------------------------------------------------------+
void CEasyXmlNode::setAttribute(string pName,string pValue)
  {
   CEasyXmlAttribute *Attribute=new CEasyXmlAttribute;

   Attribute.setName(pName);
   Attribute.setValue(pValue);

   AttributeNodes.Add(Attribute);
  }
//+------------------------------------------------------------------+
//| get attribute                                                    |
//+------------------------------------------------------------------+
string CEasyXmlNode::getAttribute(string pName)
  {
   CEasyXmlAttribute *Attribute;

   for(int i=0; i<AttributeNodes.Total(); i++) 
     {
      Attribute=AttributeNodes.At(i);

      if(Attribute.getName()==pName) 
        {
         return Attribute.getValue();
        }
     }

   return("");
  }
//+------------------------------------------------------------------+
//| get tag name                                                     |
//+------------------------------------------------------------------+
string CEasyXmlNode::getName(void)
  {
   return sName;
  }
//+------------------------------------------------------------------+
//| set tag content value                                            |
//+------------------------------------------------------------------+
string CEasyXmlNode::getValue(void)
  {
   return sValue;
  }
//+------------------------------------------------------------------+
//| get child nodes                                                  |
//+------------------------------------------------------------------+
CArrayObj *CEasyXmlNode::Children(void)
  {
   return ChildNodes;
  }
//+------------------------------------------------------------------+
//| get Attributes                                                   |
//+------------------------------------------------------------------+
CArrayObj *CEasyXmlNode::Attributes(void)
  {
   return AttributeNodes;
  }
//+------------------------------------------------------------------+
//| create child node                                                |
//+------------------------------------------------------------------+
CEasyXmlNode *CEasyXmlNode::createChild(CEasyXmlNode *pChildNode)
  {
   pChildNode.Parent(GetPointer(this));
   ChildNodes.Add(pChildNode);

   return(ChildNodes.At(ChildNodes.Total()-1));
  }
//+------------------------------------------------------------------+
//| create sibling node                                              |
//+------------------------------------------------------------------+
CEasyXmlNode *CEasyXmlNode::createSibling(CEasyXmlNode *pSiblingNode)
  {
   pSiblingNode.Prev(GetPointer(this));
   GetPointer(this).Next(pSiblingNode);

   ParentNode.createChild(pSiblingNode);
   return ParentNode.LastChild();
  }
//+------------------------------------------------------------------+
//| get last child node in array                                     |
//+------------------------------------------------------------------+
CEasyXmlNode *CEasyXmlNode::FirstChild(void)
  {
   return ChildNodes.At(0);
  }
//+------------------------------------------------------------------+
//| get last child node in array                                     |
//+------------------------------------------------------------------+
CEasyXmlNode *CEasyXmlNode::LastChild(void)
  {
   return ChildNodes.At(ChildNodes.Total()-1);
  }
//+------------------------------------------------------------------+
//| get parent node                                                  |
//+------------------------------------------------------------------+
CEasyXmlNode *CEasyXmlNode::Parent(void)
  {
   return ParentNode;
  }
//+------------------------------------------------------------------+
//| set parent node                                                  |
//+------------------------------------------------------------------+
void CEasyXmlNode::Parent(CEasyXmlNode *pParentNode)
  {
   ParentNode=pParentNode;
  }
//+------------------------------------------------------------------+
