//+------------------------------------------------------------------+
//|                                             IndicatorWithCSM.mq5 |
//|                           Copyright 2019, Alexander Shukalovich. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2020, Alexander Shukalovich."
#property link      "https://www.mql5.com/en/users/nomadmain"
#property version   "1.00"

#property indicator_separate_window
#property indicator_buffers 8
#property indicator_plots   8

#property indicator_label1  "AUD"
#property indicator_label2  "CAD"
#property indicator_label3  "CHF"
#property indicator_label4  "EUR"
#property indicator_label5  "GBP"
#property indicator_label6  "JPY"
#property indicator_label7  "NZD"
#property indicator_label8  "USD"

#property indicator_levelcolor   clrSilver
#property indicator_levelstyle   STYLE_DOT

// Current chart plors params which will be show CSM data
#property indicator_color1       clrSteelBlue
#property indicator_width1       2
#property indicator_type1        DRAW_LINE
#property indicator_style1       STYLE_SOLID

#property indicator_color2       clrDarkOrange
#property indicator_width2       2
#property indicator_type2        DRAW_LINE
#property indicator_style2       STYLE_SOLID

#property indicator_color3       clrGold
#property indicator_width3       2
#property indicator_type3        DRAW_LINE
#property indicator_style3       STYLE_SOLID

#property indicator_color4       clrAqua
#property indicator_width4       2
#property indicator_type4        DRAW_LINE
#property indicator_style4       STYLE_SOLID

#property indicator_color5       clrRed
#property indicator_width5       2
#property indicator_type5        DRAW_LINE
#property indicator_style5       STYLE_SOLID

#property indicator_color6       clrLime
#property indicator_width6       2
#property indicator_type6        DRAW_LINE
#property indicator_style6       STYLE_SOLID

#property indicator_color7       clrMagenta
#property indicator_width7       2
#property indicator_type7        DRAW_LINE
#property indicator_style7       STYLE_SOLID

#property indicator_color8       clrDarkGray
#property indicator_width8       2
#property indicator_type8        DRAW_LINE
#property indicator_style8       STYLE_SOLID

// Current indicator buffers which will be store CSM data
double audBuffer[];
double cadBuffer[];
double chfBuffer[];
double eurBuffer[];
double gbpBuffer[];
double jpyBuffer[];
double nzdBuffer[];
double usdBuffer[];

// CSM indicator handle
int g_handle;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnInit()
  {
// Buind buffers with plot indexies
   SetIndexBuffer(0, audBuffer, INDICATOR_DATA);
   SetIndexBuffer(1, cadBuffer, INDICATOR_DATA);
   SetIndexBuffer(2, chfBuffer, INDICATOR_DATA);
   SetIndexBuffer(3, eurBuffer, INDICATOR_DATA);
   SetIndexBuffer(4, gbpBuffer, INDICATOR_DATA);
   SetIndexBuffer(5, jpyBuffer, INDICATOR_DATA);
   SetIndexBuffer(6, nzdBuffer, INDICATOR_DATA);
   SetIndexBuffer(7, usdBuffer, INDICATOR_DATA);

   ResetLastError();

// Initializing of CMS indicator
   g_handle = iCustom(
                 NULL,       // Symbol for CMS
                 PERIOD_H1,  // Period for CMS
                 "Market\\Currency Strength Meter Pro for EA MT5",     // Indicator path
                 0,          // Latency (Refresh delay in seconds) 0 means every tick
                 3,          // Log level (Trace = 0, Info = 1, Warning = 2, Error = 3, Critical = 4)
                 90,         // Candles for calculation
                 0,          // Candles shift from the beginning
                 false,      // Use Moving Average smoothing
                 0,          // Moving Average Period for smoothing
                 0,          // Moving Average Method for smoothing (MODE_SMA = 0 (Simple averaging), MODE_EMA = 1 (Exponential averaging), MODE_SMMA = 2 (Smoothed averaging), MODE_LWMA = 3 (Linear-weighted averaging))
                 true,       // Auto detect symbols suffix ("Use suffix" should be disabled)
                 false,      // Use suffix
                 "",         // Symbols Suffix
                 0,          // CSM algorithm type (RSI = 0, CCI = 1, RVI = 2, MFI = 3, Stochastic = 4, DeMarket = 5, Momentum = 6)
                 ""          // CSM algorithm params (Empty string means default params)
              );

// Check that CMS indicator was initialised successfully
   if(g_handle == INVALID_HANDLE)
     {
      Print("g_handle = ", g_handle, " error = ", GetLastError());
      return INIT_FAILED;
     }

   return INIT_SUCCEEDED;
  }


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
// Copying CMS data to current chart buffers
   CopyBuffer(g_handle, 0, 0, rates_total, audBuffer);
   CopyBuffer(g_handle, 1, 0, rates_total, cadBuffer);
   CopyBuffer(g_handle, 2, 0, rates_total, chfBuffer);
   CopyBuffer(g_handle, 3, 0, rates_total, eurBuffer);
   CopyBuffer(g_handle, 4, 0, rates_total, gbpBuffer);
   CopyBuffer(g_handle, 5, 0, rates_total, jpyBuffer);
   CopyBuffer(g_handle, 6, 0, rates_total, nzdBuffer);
   CopyBuffer(g_handle, 7, 0, rates_total, usdBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
