#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/integer"
#property version   "1.00"

#property strict
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots    1
//--- plot Label1
#property indicator_label1  "vhf"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1

/*
    "- ".
   
   :
   
   VHFPeriod -  
*/

extern int VHFPeriod=14; /*VHFPeriod*/  //  

double         Label1Buffer1[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit(){
   SetIndexBuffer(0,Label1Buffer1);
   
   SetIndexLabel(0,"VHF2");
   
   IndicatorDigits(Digits+1);
   
   SetIndexDrawBegin(0,VHFPeriod);   
   
   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]){

   int limit=rates_total-prev_calculated;

   if(prev_calculated==0){
      limit--;
      limit-=VHFPeriod;
   }
   
   for(int i=limit;i>=0;i--){
      double sm=0;
      int e=i+VHFPeriod;
         for (int j=i;j<e;j++){
            sm+=MathAbs(Close[j]-Close[j+1]);
         }   
         if(sm==0){
            Label1Buffer1[i]=Label1Buffer1[i+1];
         }
         else{
            Label1Buffer1[i]=(Close[i]-Close[i+VHFPeriod])/sm;         
         }
   }      

   return(rates_total);
  }
//+------------------------------------------------------------------+
