#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/integer"
#property version   "1.00"

#property strict

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_plots 2

#property indicator_label1  "up"
#property indicator_type1   DRAW_ARROW
#property indicator_color1  clrAqua
#property indicator_style1  STYLE_SOLID

#property indicator_label2  "dn"
#property indicator_type2   DRAW_ARROW
#property indicator_color2  clrDeepPink
#property indicator_style2  STYLE_SOLID

/*
         .
   
   :
   
   FastMAPeriod -   
   FastMAMethod -   : 0-SMA, 1-EMA, 2-SMMA, 3-LWMA
   FastMAPrice -   : 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-Weighted
   FastMAShift -   
   SlowMAPeriod -   
   SlowMAMethod -   : 0-SMA, 1-EMA, 2-SMMA, 3-LWMA
   SlowMAPrice -   : 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-Weighted
   SlowMAShift -   
   
   
*/

extern int FastMAPeriod =  5;    /*FastMAPeriod*/  //   
extern int FastMAMethod =  0;    /*FastMAMethod*/  //   : 0-SMA, 1-EMA, 2-SMMA, 3-LWMA
extern int FastMAPrice  =  4;    /*FastMAPrice*/   //   : 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-Weighted
extern int FastMAShift  =  0;    /*FastMAShift*/   //   
extern int SlowMAPeriod =  34;   /*SlowMAPeriod*/  //   
extern int SlowMAMethod =  0;    /*SlowMAMethod*/  //   : 0-SMA, 1-EMA, 2-SMMA, 3-LWMA
extern int SlowMAPrice  =  4;    /*SlowMAPrice*/   //   : 0-Close, 1-Open, 2-High, 3-Low, 4-Median, 5-Typical, 6-Weighted
extern int SlowMAShift  =  0;    /*SlowMAShift*/   //   

double         up[];
double         dn[];

double pt;
int drb;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit(){

   pt=Point*PTA(Period());

   SetIndexBuffer(0,up);
   SetIndexArrow(0,233);
   SetIndexEmptyValue(0,0);
   
   SetIndexBuffer(1,dn);
   SetIndexArrow(1,234);
   SetIndexEmptyValue(1,0);
   
   drb=1+MathMax(fMADrawBegin(FastMAPeriod,FastMAMethod)+FastMAShift,fMADrawBegin(SlowMAPeriod,SlowMAMethod)+SlowMAShift);

   return(INIT_SUCCEEDED);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]){

   int limit=rates_total-prev_calculated;

   if(prev_calculated==0){
      limit--;
   }
   
   for(int i=limit;i>=0;i--){
      double fast_ma0=iMA(NULL,0,FastMAPeriod,0,FastMAMethod,FastMAPrice,i+FastMAShift);
      double slow_ma0=iMA(NULL,0,SlowMAPeriod,0,SlowMAMethod,SlowMAPrice,i+SlowMAShift);
      double fast_ma1=iMA(NULL,0,FastMAPeriod,0,FastMAMethod,FastMAPrice,i+1+FastMAShift);
      double slow_ma1=iMA(NULL,0,SlowMAPeriod,0,SlowMAMethod,SlowMAPrice,i+1+SlowMAShift);
      up[i]=0;
      dn[i]=0;
      
         if(fast_ma0>slow_ma0){
            if(fast_ma1<=slow_ma1){
               up[i]=Low[i]-pt;     
            }
         }
         if(fast_ma0<slow_ma0){
            if(fast_ma1>=slow_ma1){
               dn[i]=High[i]+pt;  
            }
         }
   }      

   return(rates_total);
  }
//+------------------------------------------------------------------+


int PTA(int aPeriod){
      switch(aPeriod){
         case PERIOD_M1:
            return(4);
         case PERIOD_M5:
            return(6);
         case PERIOD_M15:
            return(8);
         case PERIOD_M30:
            return(13);             
         case PERIOD_H1:
            return(17);  
         case PERIOD_H4:
            return(40);  
         case PERIOD_D1:
            return(70);                   
         case PERIOD_W1:
            return(150); 
         case PERIOD_MN1:
            return(300);          
      }
   return(5);
}

int fMADrawBegin(int aPeriod,int aMethod){
      switch(aMethod){
         case 1: return(10*aPeriod);
         case 2: return(20*aPeriod);      
      }
   return(aPeriod);    
}
