# KongAI EA - Kompletan Vodič za Korišćenje

## Sadržaj
1. [Uvod](#uvod)
2. [Načini Korišćenja](#načini-korišćenja)
3. [Input Parametri](#input-parametri)
4. [Proces Treniranja Modela](#proces-treniranja-modela)
5. [Live Mod sa Pre-treniranim Modelom](#live-mod-sa-pre-treniranim-modelom)
6. [Live Mod bez Pre-treniranog Modela](#live-mod-bez-pre-treniranog-modela)
7. [Auto-treniranje na Live](#auto-treniranje-na-live)
8. [Najbolje Prakse](#najbolje-prakse)

---

## Uvod

KongAI EA je napredni neuro expert advisor koji koristi mašinsko učenje za trgovanje. EA može raditi u dva osnovna moda:
- **Bez pre-treniranog modela** - uči se u realnom vremenu
- **Sa pre-treniranim modelom** - koristi model dobijen iz optimizacije/testiranja

---

## Načini Korišćenja

### 1. Direktna Aktivacija na Live (Bez Pre-treniranog Modela)
- EA se postavi na chart i odmah počinje da uči
- Model se gradi od nule u realnom vremenu
- Prvih nekoliko sati/dana EA uči i prilagođava se tržištu
- Preporučuje se za nove simbole ili kada nemate dostupan model

### 2. Korišćenje sa Pre-treniranim Modelom
- Model se dobija kroz proces optimizacije ili testiranja
- Baza podataka se kopira iz `Tester` foldera u `Files` folder
- EA odmah počinje sa kvalitetnim signalima
- Preporučuje se za proverene strategije

---

## Input Parametri

### 📊 Osnovni Parametri
- **MagicNumber**: Magični broj EA (jedinstven za svaki EA)
- **LotSize**: Veličina lota (0.01 za standardni)
- **MaxPositions**: Maksimalan broj otvorenih pozicija (1-10)
- **StopLoss**: Stop loss u pipsima (20-200)
- **TakeProfit**: Take profit u pipsima (20-500)

### 🧠 Neuralska Mreža
- **NumberOfEpochs**: Broj epoha treniranja (50-1000)
- **LearningRate**: Stopa učenja (0.001-0.1)
- **threshold**: Prag odluke (1.0-4.0)
- **globalFactor**: Gradijent faktor (-1.0 do -5.0)

### 📈 Analiza Tržišta
- **EnableRegimeDetection**: Detekcija režima tržišta (true/false)
- **RegimeLookbackPeriod**: Period za analizu režima (50-500)
- **TrendingThreshold**: Prag za trending tržište (0.5-0.9)
- **VolatilityThreshold**: Prag volatilnosti (0.005-0.1)
- **RegimeConfidenceThreshold**: Pouzdanost režima (0.5-0.95)

### 📰 News Filter
- **EnableNewsFilter**: Master switch za news filter (true/false)
- **MinsBeforeHighImpact**: Minuta pre high impact news (5-120)
- **MinsAfterHighImpact**: Minuta posle high impact news (5-120)
- **BlockLowImportance**: Blokiraj low importance news (true/false)

### 💭 Sentiment Analiza
- **EnableSentimentAnalysis**: Omogući sentiment analizu (true/false)
- **SentimentThreshold**: Min sentiment skor (0.1-0.8)
- **SentimentWeightFactor**: Uticaj sentimenta na težine (0.0-1.0)
- **SentimentLookbackHours**: Sati za sentiment analizu (1-168)
- **SentimentConfidenceThreshold**: Pouzdanost sentimenta (0.5-0.95)
- **SentimentCorrelationWindow**: Window za korelaciju (20-500)

### 🎯 Weight Boosting
- **EnableWeightBoosting**: Pojačavanje težina (true/false)
- **MinWinRateForBoost**: Min WinRate za boost (0.5-0.9)
- **WeightBoostFactor**: Faktor množenja težina (1.0-2.0)

### 🛡️ Zaštita od Gubitaka
- **EnableConsecutiveLossProtection**: Zaštita od gubitaka (true/false)
- **MaxConsecutiveLosses**: Max uzastopnih gubitaka (1-10)
- **ConsecutiveLossPauseHours**: Sati pauze (1-168)
- **ReduceLotSizeAfterLosses**: Smanjenje lota (0.1-0.9)

### 📚 Learning Rate
- **EnableLearningRateDecay**: Decay learning rate (true/false)
- **LRDecayFactor**: Faktor decay-a (0.8-0.99)
- **LRDecayEpochs**: Epoha za decay (10-500)
- **MinLearningRate**: Min learning rate (0.0001-0.01)

### 🛑 Early Stopping
- **EnableEarlyStopping**: Early stopping (true/false)
- **MinImprovement**: Min poboljšanje (0.0001-0.05)
- **PatienceEpochs**: Strpljenje u epohama (10-200)
- **ValidationSplit**: % za validaciju (5-50%)

### 👥 Ensemble Metode
- **EnableEnsembleSignals**: Ensemble signali (true/false)
- **EnsembleSize**: Veličina ensemble-a (2-10)
- **EnsembleThreshold**: Prag ensemble (0.5-0.95)
- **EnsemblePerformanceWindow**: Window za performanse (20-100)

### ⚠️ Risk Management
- **MaxDailyDrawdownPct**: Max dnevni drawdown (%)
- **EnableEquityGuardian**: Equity guardian (true/false)
- **EnableCorrelationFilter**: Filter korelacije (true/false)

### 🔧 Verbose Control
- **printLogMessages**: Detaljni logovi (true/false)
- **VerboseNeural**: Neural detalji (true/false)
- **VerboseDatabase**: Database operacije (true/false)
- **VerboseTraining**: Treniranje detalji (true/false)
- **VerboseNews**: News filter detalji (true/false)
- **VerboseRisk**: Risk management detalji (true/false)
- **VerbosePerformance**: Performance detalji (true/false)

---

## Proces Treniranja Modela

### Korak 1: Optimizacija
1. Otvorite MetaTrader 5 Strategy Tester
2. Postavite KongAI EA
3. Izaberite simbol i timeframe
4. Podesite optimizacione parametre:
   - **NumberOfEpochs**: 100-500
   - **LearningRate**: 0.01-0.05
   - **ValidationSplit**: 20-30%
5. Pokrenite optimizaciju
6. Sačekajte završetak

### Korak 2: Testiranje
1. Izaberite najbolje parametre iz optimizacije
2. Pokrenite backtest sa tim parametrima
3. Proverite performanse i stabilnost
4. Ako su rezultati zadovoljavajući, nastavite

### Korak 3: Ekstrakcija Modela
1. Nakon testiranja, model se nalazi u `Tester` folderu
2. Putanja: `MT5/MQL5/Files/Tester/[Broker]/[Symbol]/[EA_Name]/database.db`
3. Kopirajte `database.db` fajl

### Korak 4: Instalacija Modela
1. Idite u `Files` folder: `MT5/MQL5/Files/[EA_Name]/`
2. Napravite folder ako ne postoji
3. Nalepite `database.db` fajl
4. EA će automatski prepoznati model

---

## Live Mod sa Pre-treniranim Modelom

### Priprema
1. **Prekopirajte bazu**: Iz `Tester` foldera u `Files` folder
2. **Proverite integritet**: Baza mora biti kompletna
3. **Postavite parametre**: Koristite iste parametre kao u optimizaciji

### Aktivacija
1. Postavite EA na chart
2. Ulogujte se (ako je potrebno)
3. EA će:
   - Detektovati postojeću bazu
   - Učitati pre-trenirani model
   - Početi sa trgovanjem odmah
   - Nastaviti da uči i adaptira se

### Prednosti
- **Brzi početak**: Nema perioda učenja
- **Kvalitetni signali**: Proveren model
- **Stabilnost**: Manje rizika

---

## Live Mod bez Pre-treniranog Modela

### Priprema
1. **Postavite EA**: Na željeni chart
2. **Podesite parametre**: Konzervativnije vrednosti
3. **Omogući učenje**: `NumberOfEpochs > 0`

### Aktivacija
1. EA će:
   - Kreirati novu bazu podataka
   - Početi da sakuplja podatke
   - Trenirati model u realnom vremenu
   - Prvi signali nakon nekog vremena

### Period Učenja
- **Prvih 1-2 sata**: Sakupljanje podataka
- **Prvih 4-8 sati**: Početak treninga
- **Posle 24 sata**: Stabilniji signali

### Prednosti
- **Adaptivnost**: Prilagođava se trenutnom tržištu
- **Svakodnevno učenje**: Konstantno poboljšanje
- **Nema potrebe za optimizacijom**

---

## Auto-treniranje na Live

### Kada se Aktivira
EA automatski pokreće treniranje kada:
- **Ima dovoljno podataka**: Minimum 1000 barova
- **WinRate je nizak**: Ispod 50%
- **Period osvežavanja**: Svakih N sati/dana

### Parametri za Auto-treniranje
- **NumberOfEpochs**: Koliko epoha po treniranju
- **LearningRate**: Stopa učenja
- **ValidationSplit**: Koliko podataka za validaciju
- **EnableEarlyStopping**: Zaustavljanje ako nema poboljšanja

### Proces Auto-treniranja
1. **Sakupljanje podataka**: Poslednjih N barova
2. **Podela podataka**: Training/Validation
3. **Treniranje**: Kroz N epoha
4. **Validacija**: Provera performansi
5. **Ažuriranje**: Novi model zamenjuje stari

---

## Najbolje Prakse

### 🎯 Pre Treniranja
1. **Testirajte različite simbole**: Nisu svi simvoli jednaki
2. **Koristite dovoljno podataka**: Minimum 6 meseci
3. **Optimizujte parametre**: Nemojte koristiti default vrednosti
4. **Validirajte model**: Proverite na out-of-sample podacima

### 📊 Monitoring
1. **Pratite WinRate**: Treba biti iznad 50%
2. **Gledajte drawdown**: Ne sme biti prevelik
3. **Analizirajte signale**: Proverite kvalitet
4. **Logujte performanse**: Koristite verbose opcije

### 🎲 Automatsko Podešavanje Lot Size-a

EA automatski **smanjuje** lot size na osnovu uzastopnih gubitaka:

#### Osnovni Input Parametri
- **LotSize**: Početni lot size (npr. 0.01)
- **MaxPositions**: Maksimalan broj pozicija
- **ReduceLotSizeAfterLosses**: Faktor smanjenja (0.1-0.9)

#### Kako Radi ReduceLotSizeAfterLosses
1. **Praćenje gubitaka**: Broji uzastopne gubitke
2. **Aktivacija**: Posle MaxConsecutiveLosses gubitaka
3. **Smanjenje lota**: mLots × ReduceLotSizeAfterLosses
4. **Reset**: Vraća originalni lot posle pobede

#### Primer Rada
```
Početni lot: 0.01
ReduceLotSizeAfterLosses: 0.5 (50% smanjenje)
MaxConsecutiveLosses: 3

1. Gubitak #1: Lot ostaje 0.01
2. Gubitak #2: Lot ostaje 0.01  
3. Gubitak #3: Lot se smanjuje na 0.005
4. Pobeda: Lot se vraća na 0.01
```

#### Lotovi Veći od 1.0
EA podržava i lotove veće od 1.0:

**Primer za lot 1.5:**
```
Početni lot: 1.5
ReduceLotSizeAfterLosses: 0.5 (50% smanjenje)

1. Gubitak #1: Lot ostaje 1.5
2. Gubitak #2: Lot ostaje 1.5
3. Gubitak #3: Lot se smanjuje na 0.75
4. Pobeda: Lot se vraća na 1.5
```

**Primer za lot 2.0:**
```
Početni lot: 2.0
ReduceLotSizeAfterLosses: 0.7 (30% smanjenje)

1. Gubitak #1: Lot ostaje 2.0
2. Gubitak #2: Lot ostaje 2.0
3. Gubitak #3: Lot se smanjuje na 1.4
4. Pobeda: Lot se vraća na 2.0
```

#### Automatska Validacija Lotova
EA automatski proverava i validira lot size:
- **SYMBOL_VOLUME_MIN**: Minimalni dozvoljeni lot (npr. 0.01)
- **SYMBOL_VOLUME_MAX**: Maksimalni dozvoljeni lot (npr. 100.0)
- **SYMBOL_VOLUME_STEP**: Korak lota (npr. 0.01)

**Primer validacije:**
```
Input lot: 1.55
Broker step: 0.01
Final lot: 1.55 (validno)

Input lot: 1.556
Broker step: 0.01
Final lot: 1.55 (zaokruženo na step)
```

#### Kod Logike
```cpp
if (g_ConsecutiveLossCount >= MaxConsecutiveLosses) {
   // Smanji lot samo ako nije već smanjen
   if (!g_LotSizeReduced) {
      g_OriginalLotSize = mLots;
      Lots = Lots * ReduceLotSizeAfterLosses;
      g_LotSizeReduced = true;
   }
}

// Reset na pobedu
if (isWinningTrade && g_LotSizeReduced) {
   Lots = g_OriginalLotSize;
   g_LotSizeReduced = false;
}
```

#### Uslovi za Lot Size
- **Minimalni lot**: 0.01 (standardni)
- **Maksimalni lot**: Zavisno od brokera
- **Validacija**: EA proverava da je lot u dozvoljenom range-u

#### Monitoring Lot Smanjenja
U logovima možete videti:
```
❌ Consecutive Loss Protection: Loss #3 recorded (Max: 3)
💰 Lot size reduced from 0.01 to 0.005 (50.0% reduction)
✅ Consecutive Loss Protection: Win detected, resetting loss count from 3 to 0
💰 Restored original lot size to 0.01
```

#### Važne Napomene
- **Samo smanjenje**: EA ne povećava lot automatski
- **Reset na pobedu**: Lot se vraća na originalnu vrednost
- **Jednokratno**: Lot se smanjuje samo jednom po seriji gubitaka
- **Trajno do pobede**: Smanjeni lot ostaje dok se ne desi pobeda

### 🔄 Održavanje
1. **Redovno trenirajte**: Svakih 1-2 nedelje
2. **Ažurirajte model**: Pratite promene tržišta
3. **Backup baze**: Čuvaj stare modele
4. **Testirajte nove parametre**: Optimizacija je ključ

### ⚠️ Upozorenja
1. **Nemojte optimisati previše**: Overfitting opasnost
2. **Pratite slippage**: Može uticati na performanse
3. **Gledajte spread**: Visoki spread uništava profit
4. **Budite realistični**: Nema svetog grala

---

## Troubleshooting

### 🐛 Česti Problemi

**EA ne radi**
- Proverite MagicNumber
- Proverite da li je EA dozvoljen
- Proverite logove

**Nema signala**
- Proverite da li ima dovoljno podataka
- Proverite parametre threshold
- Proverite news filter

**Losi rezultati**
- Smanjite LearningRate
- Povećajte NumberOfEpochs
- Proverite RegimeDetection

**Baza ne radi**
- Proverite putanju do baze
- Proverite dozvole fajla
- Restartujte EA

---

## Zaključak

KongAI EA je moćan alat koji kombinuje neuronske mreže, sentiment analizu i napredni risk management. Ključ uspeha leži u:
- **Dobrom podešavanju parametara**
- **Kvalitetnom treniranju modela**
- **Redovnom monitoringu**
- **Prilagođavanju tržišnim uslovima**

Sledite ovaj vodiž, eksperimentišite, i najvažnije - budite strpljivi. Dobri AI modeli vremena se grade i konstantno se unapređuju.

**Srećno u trgovanju!** 🚀
