# KongAI EA - Complete User Guide

## Table of Contents
1. [Introduction](#introduction)
2. [Usage Methods](#usage-methods)
3. [Input Parameters](#input-parameters)
4. [Model Training Process](#model-training-process)
5. [Live Mode with Pre-trained Model](#live-mode-with-pre-trained-model)
6. [Live Mode without Pre-trained Model](#live-mode-without-pre-trained-model)
7. [Auto-training on Live](#auto-training-on-live)
8. [Best Practices](#best-practices)

---

## Introduction

KongAI EA is an advanced neural network expert advisor that uses machine learning for trading. The EA can operate in two basic modes:
- **Without pre-trained model** - learns in real-time
- **With pre-trained model** - uses model obtained from optimization/testing

---

## Usage Methods

### 1. Direct Live Activation (Without Pre-trained Model)
- Place EA on chart and start learning immediately
- Model is built from scratch in real-time
- First few hours/days EA learns and adapts to market
- Recommended for new symbols or when you don't have available model

### 2. Using Pre-trained Model
- Model is obtained through optimization or testing process
- Database is copied from `Tester` folder to `Files` folder
- EA starts immediately with quality signals
- Recommended for proven strategies

---

## Input Parameters

### 📊 Basic Parameters
- **MagicNumber**: EA magic number (unique for each EA)
- **LotSize**: Lot size (0.01 for standard)
- **MaxPositions**: Maximum open positions (1-10)
- **StopLoss**: Stop loss in pips (20-200)
- **TakeProfit**: Take profit in pips (20-500)

### 🧠 Neural Network
- **NumberOfEpochs**: Number of training epochs (50-1000)
- **LearningRate**: Learning rate (0.001-0.1)
- **threshold**: Decision threshold (1.0-4.0)
- **globalFactor**: Gradient factor (-1.0 to -5.0)

### 📈 Market Analysis
- **EnableRegimeDetection**: Market regime detection (true/false)
- **RegimeLookbackPeriod**: Regime analysis period (50-500)
- **TrendingThreshold**: Trending market threshold (0.5-0.9)
- **VolatilityThreshold**: Volatility threshold (0.005-0.1)
- **RegimeConfidenceThreshold**: Regime confidence (0.5-0.95)

### 📰 News Filter
- **EnableNewsFilter**: Master switch for news filter (true/false)
- **MinsBeforeHighImpact**: Minutes before high impact news (5-120)
- **MinsAfterHighImpact**: Minutes after high impact news (5-120)
- **BlockLowImportance**: Block low importance news (true/false)

### 💭 Sentiment Analysis
- **EnableSentimentAnalysis**: Enable sentiment analysis (true/false)
- **SentimentThreshold**: Min sentiment score (0.1-0.8)
- **SentimentWeightFactor**: Sentiment influence on weights (0.0-1.0)
- **SentimentLookbackHours**: Hours for sentiment analysis (1-168)
- **SentimentConfidenceThreshold**: Sentiment confidence (0.5-0.95)
- **SentimentCorrelationWindow**: Correlation window (20-500)

### 🎯 Weight Boosting
- **EnableWeightBoosting**: Weight boosting (true/false)
- **MinWinRateForBoost**: Min WinRate for boost (0.5-0.9)
- **WeightBoostFactor**: Weight multiplication factor (1.0-2.0)

### 🛡️ Loss Protection
- **EnableConsecutiveLossProtection**: Loss protection (true/false)
- **MaxConsecutiveLosses**: Max consecutive losses (1-10)
- **ConsecutiveLossPauseHours**: Pause hours (1-168)
- **ReduceLotSizeAfterLosses**: Lot reduction (0.1-0.9)

### 📚 Learning Rate
- **EnableLearningRateDecay**: Learning rate decay (true/false)
- **LRDecayFactor**: Decay factor (0.8-0.99)
- **LRDecayEpochs**: Epochs for decay (10-500)
- **MinLearningRate**: Min learning rate (0.0001-0.01)

### 🛑 Early Stopping
- **EnableEarlyStopping**: Early stopping (true/false)
- **MinImprovement**: Min improvement (0.0001-0.05)
- **PatienceEpochs**: Patience in epochs (10-200)
- **ValidationSplit**: % for validation (5-50%)

### 👥 Ensemble Methods
- **EnableEnsembleSignals**: Ensemble signals (true/false)
- **EnsembleSize**: Ensemble size (2-10)
- **EnsembleThreshold**: Ensemble threshold (0.5-0.95)
- **EnsemblePerformanceWindow**: Performance window (20-100)

### ⚠️ Risk Management
- **MaxDailyDrawdownPct**: Max daily drawdown (%)
- **EnableEquityGuardian**: Equity guardian (true/false)
- **EnableCorrelationFilter**: Correlation filter (true/false)

### 🔧 Verbose Control
- **printLogMessages**: Detailed logs (true/false)
- **VerboseNeural**: Neural details (true/false)
- **VerboseDatabase**: Database operations (true/false)
- **VerboseTraining**: Training details (true/false)
- **VerboseNews**: News filter details (true/false)
- **VerboseRisk**: Risk management details (true/false)
- **VerbosePerformance**: Performance details (true/false)

---

## Model Training Process

### Step 1: Optimization
1. Open MetaTrader 5 Strategy Tester
2. Set up KongAI EA
3. Select symbol and timeframe
4. Set optimization parameters:
   - **NumberOfEpochs**: 100-500
   - **LearningRate**: 0.01-0.05
   - **ValidationSplit**: 20-30%
5. Run optimization
6. Wait for completion

### Step 2: Testing
1. Select best parameters from optimization
2. Run backtest with those parameters
3. Check performance and stability
4. If results are satisfactory, continue

### Step 3: Model Extraction
1. After testing, model is in `Tester` folder
2. Path: `MT5/MQL5/Files/Tester/[Broker]/[Symbol]/[EA_Name]/database.db`
3. Copy `database.db` file

### Step 4: Model Installation
1. Go to `Files` folder: `MT5/MQL5/Files/[EA_Name]/`
2. Create folder if doesn't exist
3. Paste `database.db` file
4. EA will automatically recognize model

---

## Live Mode with Pre-trained Model

### Preparation
1. **Copy database**: From `Tester` folder to `Files` folder
2. **Check integrity**: Database must be complete
3. **Set parameters**: Use same parameters as in optimization

### Activation
1. Place EA on chart
2. Login if required
3. EA will:
   - Detect existing database
   - Load pre-trained model
   - Start trading immediately
   - Continue learning and adapting

### Advantages
- **Fast start**: No learning period
- **Quality signals**: Proven model
- **Stability**: Less risk

---

## Live Mode without Pre-trained Model

### Preparation
1. **Set up EA**: On desired chart
2. **Set parameters**: More conservative values
3. **Enable learning**: `NumberOfEpochs > 0`

### Activation
1. EA will:
   - Create new database
   - Start collecting data
   - Train model in real-time
   - First signals after some time

### Learning Period
- **First 1-2 hours**: Data collection
- **First 4-8 hours**: Training begins
- **After 24 hours**: More stable signals

### Advantages
- **Adaptability**: Adapts to current market
- **Daily learning**: Constant improvement
- **No optimization needed**

---

## Auto-training on Live

### When Activated
EA automatically starts training when:
- **Enough data available**: Minimum 1000 bars
- **WinRate is low**: Below 50%
- **Refresh period**: Every N hours/days

### Auto-training Parameters
- **NumberOfEpochs**: How many epochs per training
- **LearningRate**: Learning rate
- **ValidationSplit**: How much data for validation
- **EnableEarlyStopping**: Stop if no improvement

### Auto-training Process
1. **Data collection**: Last N bars
2. **Data split**: Training/Validation
3. **Training**: Through N epochs
4. **Validation**: Check performance
5. **Update**: New model replaces old one

---

## Best Practices

### 🎯 Before Training
1. **Test different symbols**: Not all symbols are equal
2. **Use enough data**: Minimum 6 months
3. **Optimize parameters**: Don't use default values
4. **Validate model**: Check on out-of-sample data

### 📊 Monitoring
1. **Track WinRate**: Should be above 50%
2. **Watch drawdown**: Shouldn't be too high
3. **Analyze signals**: Check quality
4. **Log performance**: Use verbose options

### 🎲 Automatic Lot Size Adjustment

EA automatically **reduces** lot size based on consecutive losses:

#### Basic Input Parameters
- **LotSize**: Initial lot size (e.g. 0.01)
- **MaxPositions**: Maximum number of positions
- **ReduceLotSizeAfterLosses**: Reduction factor (0.1-0.9)

#### How ReduceLotSizeAfterLosses Works
1. **Track losses**: Count consecutive losses
2. **Activation**: After MaxConsecutiveLosses losses
3. **Lot reduction**: mLots × ReduceLotSizeAfterLosses
4. **Reset**: Return original lot after win

#### Example Operation
```
Initial lot: 0.01
ReduceLotSizeAfterLosses: 0.5 (50% reduction)
MaxConsecutiveLosses: 3

1. Loss #1: Lot remains 0.01
2. Loss #2: Lot remains 0.01  
3. Loss #3: Lot reduces to 0.005
4. Win: Lot returns to 0.01
```

#### Lots Larger than 1.0
EA supports lots larger than 1.0:

**Example for lot 1.5:**
```
Initial lot: 1.5
ReduceLotSizeAfterLosses: 0.5 (50% reduction)

1. Loss #1: Lot remains 1.5
2. Loss #2: Lot remains 1.5
3. Loss #3: Lot reduces to 0.75
4. Win: Lot returns to 1.5
```

**Example for lot 2.0:**
```
Initial lot: 2.0
ReduceLotSizeAfterLosses: 0.7 (30% reduction)

1. Loss #1: Lot remains 2.0
2. Loss #2: Lot remains 2.0
3. Loss #3: Lot reduces to 1.4
4. Win: Lot returns to 2.0
```

#### Automatic Lot Validation
EA automatically checks and validates lot size:
- **SYMBOL_VOLUME_MIN**: Minimum allowed lot (e.g. 0.01)
- **SYMBOL_VOLUME_MAX**: Maximum allowed lot (e.g. 100.0)
- **SYMBOL_VOLUME_STEP**: Lot step (e.g. 0.01)

**Validation example:**
```
Input lot: 1.55
Broker step: 0.01
Final lot: 1.55 (valid)

Input lot: 1.556
Broker step: 0.01
Final lot: 1.55 (rounded to step)
```

#### Code Logic
```cpp
if (g_ConsecutiveLossCount >= MaxConsecutiveLosses) {
   // Reduce lot only if not already reduced
   if (!g_LotSizeReduced) {
      g_OriginalLotSize = mLots;
      Lots = Lots * ReduceLotSizeAfterLosses;
      g_LotSizeReduced = true;
   }
}

// Reset on win
if (isWinningTrade && g_LotSizeReduced) {
   Lots = g_OriginalLotSize;
   g_LotSizeReduced = false;
}
```

#### Lot Size Conditions
- **Minimum lot**: 0.01 (standard)
- **Maximum lot**: Depends on broker
- **Validation**: EA checks lot is in allowed range

#### Monitoring Lot Reduction
In logs you can see:
```
❌ Consecutive Loss Protection: Loss #3 recorded (Max: 3)
💰 Lot size reduced from 0.01 to 0.005 (50.0% reduction)
✅ Consecutive Loss Protection: Win detected, resetting loss count from 3 to 0
💰 Restored original lot size to 0.01
```

#### Important Notes
- **Reduction only**: EA doesn't automatically increase lot
- **Reset on win**: Lot returns to original value
- **One-time**: Lot reduces only once per series
- **Permanent until win**: Reduced lot stays until win occurs

### 🔄 Maintenance
1. **Train regularly**: Every 1-2 weeks
2. **Update model**: Follow market changes
3. **Backup database**: Keep old models
4. **Test new parameters**: Optimization is key

### ⚠️ Warnings
1. **Don't over-optimize**: Overfitting danger
2. **Watch slippage**: Can affect performance
3. **Check spread**: High spread kills profit
4. **Be realistic**: No holy grail

---

## Troubleshooting

### 🐛 Common Problems

**EA not working**
- Check MagicNumber
- Check if EA is allowed
- Check logs

**No signals**
- Check if enough data
- Check threshold parameters
- Check news filter

**Poor results**
- Reduce LearningRate
- Increase NumberOfEpochs
- Check RegimeDetection

**Database not working**
- Check database path
- Check file permissions
- Restart EA

---

## Conclusion

KongAI EA is a powerful tool that combines neural networks, sentiment analysis and advanced risk management. The key to success lies in:
- **Good parameter settings**
- **Quality model training**
- **Regular monitoring**
- **Adapting to market conditions**

Follow this guide, experiment, and most importantly - be patient. Good AI models take time to build and are constantly improved.

**Happy Trading!** 🚀
