//+------------------------------------------------------------------+
//| Rommark binary alert based on RSI+MFI+Demarker
//| tradista@tradegest.com
//+------------------------------------------------------------------+

#property copyright "tradista@tradegest.com"
#property version "1.0"
#property description "Oversold/Overbought signal based RSI+MFI+Demarker with alert."
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red

//---- external parameters
extern int RSIPeriod = 2;         // RSI Period
extern int MFIPeriod = 4;         // Money Flow Index Period
extern int DemarkerPeriod = 4;    // Demark Period
extern int RSI_OB = 90;        // RSI overbought value
extern int RSI_OS = 10;        // RSI oversold value
extern int MFI_OB = 100;       // MFI overbought value
extern int MFI_OS = 0;         // MFI oversold value
extern int Demarker_OB = 1;    // Demarker overbought value
extern int Demarker_OS = 0;    // Demarker overbought value
// extern int Step = 3;              // Max bars back to check for cross sincronicity
bool AlertOn=false;        // Enable alert
int CountBars=10000;
int ShiftSignal=0;         //Shift of signal backwards 

//---- buffers
double buy_buf[];
double sell_buf[];

datetime BarTime;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
  {
   IndicatorBuffers(2);
   
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,233);
   SetIndexBuffer(0,buy_buf);
      
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,234);
   SetIndexBuffer(1,sell_buf);
   
   return(0);
  }
  
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
int start()
  {   
   //---- wait for new bar -----------
   if(BarTime == Time[0]) {return(0);}

   //---- new bar, update bartime ----
   BarTime = Time[0];

   int i=CountBars-1;
   
   while(i>=0)
   {     
   buy_buf[i]=EMPTY_VALUE; 
   sell_buf[i]=EMPTY_VALUE; 
      
   double RSI = iRSI(NULL,0,RSIPeriod,PRICE_CLOSE,i);
   double MFI = iMFI(NULL,0,MFIPeriod,i);
   double DMK = iDeMarker(NULL,0,DemarkerPeriod,i);
   
   double RSI_b = iRSI(NULL,0,RSIPeriod,PRICE_CLOSE,i+1);
   double MFI_b = iMFI(NULL,0,MFIPeriod,i+1);
   double DMK_b = iDeMarker(NULL,0,DemarkerPeriod,i+1);   
          
   //buy signal
   
   // ************************* set buy arrow value ************************

      if ( RSI>=RSI_OS && RSI<RSI_OB && RSI_b<=RSI_OS &&
           MFI>=MFI_OS && MFI<MFI_OB && MFI_b<=MFI_OS && 
           DMK>=Demarker_OS && DMK_b<=Demarker_OS)
      {
      buy_buf[i+ShiftSignal]=Low[i]-5*Point;
      if (AlertOn==true && i<=1)         
      {
         PlaySound("alert.wav");         
         Alert(TimeMonth(CurTime()),"/",TimeDay(CurTime())," at ",TimeHour(CurTime()),":",TimeMinute(CurTime()),"   -   Possible buy on ",Symbol()," ", Period());
         }
      }

   /////////////////////////////////////////////////////////////////////////////////////////////////

      //sell signal
     if ( RSI<=RSI_OB && RSI>RSI_OS && RSI_b>=RSI_OB && 
          MFI<=MFI_OB && MFI>MFI_OS && MFI_b>=MFI_OB && 
          DMK<=Demarker_OB && DMK_b>=Demarker_OB)
      {
      // ************************* set sell arrow value ************************      
      sell_buf[i+ShiftSignal]=High[i]+5*Point;
      if (AlertOn==true && i<=1)
         {
         PlaySound("alert.wav");         
         Alert(TimeMonth(CurTime()),"/",TimeDay(CurTime())," at ",TimeHour(CurTime()),":",TimeMinute(CurTime()),"   -   Possible sell on ",Symbol()," ", Period());
         }
      }
   ///////////////////////////////////////////////////////////////////////////////////////////////////
   i--;
      
   }      
   
   return(0);
  }
  

