# Market Exhaustion Indicator v1.06 - Validator Probe Note

## Objective

Provide a single test build that removes feature complexity and isolates validator behavior.

## Probe Constraints Implemented

- Same product family/name (`Market Exhaustion Indicator`)
- New preserved version: `v1.06`
- One buffer only (`indicator_buffers 1`)
- One plot only (`DRAW_NONE`)
- No multi-timeframe logic
- No multi-symbol logic
- No `iCustom()` calls
- No `CopyRates()` / `CopyTicks()` calls
- No timers (`EventSetTimer`, `OnTimer`)
- `OnCalculate()` returns `rates_total`

## Interpretation Rule

- If this probe **passes**, validator environment is likely fine and previous failures are tied to package/code path complexity.
- If this probe **fails with the same sync error**, issue is likely validator-side and should be escalated to MetaQuotes.
