// BPNN-64.cpp : Defines the exported functions for the DLL.
//

#include "pch.h"
#include "framework.h"
#include "BPNN-64.h"

#undef MS_EXAMPLE_CLASS
#ifdef MS_EXAMPLE_CLASS
// This is an example of an exported variable
BPNN64_API int nBPNN64=0;

// This is an example of an exported function.
BPNN64_API int fnBPNN64(void)
{
    return 0;
}

// This is the constructor of a class that has been exported.
CBPNN64::CBPNN64()
{
    return;
}
#endif
#include "stdafx.h"

// ================================== NN classes & functions ==================================

class NN
{
	//	output of each neuron
	double** out;

	//	delta value for each neuron; delta[i][j]*out[i-1][k] = -dE/dw[i][j][k]
	double** delta;

	//	weights for each neuron
	double*** w;

	//	update values
	double*** d;

	//	gradients in curent epoch
	double*** g;

	//	gradient signs in previous epoch
	int*** gSign;

	//	no of layers in net including input, hidden and output layers
	int numl;

	//	number of neurons in each layer
	int* lsize;

	//	type of neuron activation function
	const int AFT;

	//	switch to turn activation function in the output layer on/off
	const int OAF;

	//	neuron activation function
	double af(double in);

	//	derivative of activation function
	double afDeriv(double out);

	//	sign function
	int sign(double val);

	//	training parameters
	double d0;
	double dmin;
	double dmax;
	double plus;
	double minus;

public:

	~NN();

	//	initialize and allocate memory
	NN(const int nl, const int* sz, const int aft, const int oaf,
		const int uew, const double* extWt);

	//	backpropogate error for one batch of input training sets
	char* xprop(double** in, double** tgt, const int ntr, int nep, const double maxMSE);

	//	feedforward activations for one set of inputs
	void ffwd(double* in);

	//	return i'th output of the net
	double Out(int i) const;

	//	return weight
	double Wt(int i, int j, int k) const;
};

//	Initialize and allocate memory on heap ---------------------------------------------------+
NN::NN(const int nl, const int* sz, const int aft, const int oaf,
	const int uew, const double* extWt) :AFT(aft), OAF(oaf)
{
	//	set training parameters
	d0 = 0.02;	// orig 0.01, opt 0.02
	dmin = 0.0;
	dmax = 50.0;	// orig 50.0
	plus = 1.2;	// orig 1.2
	minus = 0.8;	// orig 0.5, opt 0.8-0.85

	//	set number of layers and their sizes
	numl = nl;
	lsize = new int[numl];
	for (int i = 0; i < numl; i++) lsize[i] = sz[i];

	//	allocate memory for output of each neuron
	out = new double* [numl];
	for (int i = 0; i < numl; i++) out[i] = new double[lsize[i]];

	//	allocate memory for deltas
	delta = new double* [numl];
	for (int i = 1; i < numl; i++) delta[i] = new double[lsize[i]];

	//	allocate memory for weights 
	//	w[curr lr #][neuron # in curr lr][input # of curr neuron = neuron # in prev lr]
	w = new double** [numl];
	for (int i = 1; i < numl; i++) w[i] = new double* [lsize[i]];
	for (int i = 1; i < numl; i++)					// for each layer except input
		for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
			w[i][j] = new double[lsize[i - 1] + 1]; // w[][][lsize[]] is bias

	//	allocate memory for update values
	d = new double** [numl];
	for (int i = 1; i < numl; i++) d[i] = new double* [lsize[i]];
	for (int i = 1; i < numl; i++)					// for each layer except input
		for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
			d[i][j] = new double[lsize[i - 1] + 1];

	//	allocate memory for new gradients
	g = new double** [numl];
	for (int i = 1; i < numl; i++) g[i] = new double* [lsize[i]];
	for (int i = 1; i < numl; i++)					// for each layer except input
		for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
			g[i][j] = new double[lsize[i - 1] + 1];

	//	allocate memory for old gradient signs
	gSign = new int** [numl];
	for (int i = 1; i < numl; i++) gSign[i] = new int* [lsize[i]];
	for (int i = 1; i < numl; i++)					// for each layer except input
		for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
			gSign[i][j] = new int[lsize[i - 1] + 1];

	//	seed and assign random weights (uew=0), or set them equal to external weights (uew=1)
	srand((unsigned)(time(NULL)));
	int iw = 0;
	for (int i = 1; i < numl; i++)					// for each layer except input
		for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
			for (int k = 0; k <= lsize[i - 1]; k++)	// for each input of curr neuron incl bias
				if (uew == 0) w[i][j][k] = 0.6 * (rand() / (double)RAND_MAX - 0.5);
				else w[i][j][k] = extWt[iw++];

	//	initialize update values to d0 for the first epoch
	for (int i = 1; i < numl; i++)					// for each layer except input
		for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
			for (int k = 0; k <= lsize[i - 1]; k++)	// for each input of curr neuron incl bias
				d[i][j][k] = d0;

	//	initialize signs of previous gradients to 0 for the first epoch
	for (int i = 1; i < numl; i++)					// for each layer except input
		for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
			for (int k = 0; k <= lsize[i - 1]; k++)	// for each input of curr neuron incl bias
				gSign[i][j][k] = 0;

	//	Note that the following variables are not used:
	//
	//	delta[0][][]
	//	w[0][][]
	//	d[0][][]
	//	g[0][][]
	//	gSign[0][][]
	//
	//	to maintain consistancy in layer numbering: for a net having n layers, input layer is 
	//	numbered as 0th layer, first hidden layer as 1st layer, and the output layer as 
	//	(n-1)th layer. First (0th) layer just stores the inputs, hence there is no delta or 
	//	weight values corresponding to it. Its outputs out[0][] are the net inputs.
}

//	Free up memory ---------------------------------------------------------------------------+
NN::~NN()
{
	//	free out
	for (int i = 0; i < numl; i++) delete[] out[i];
	delete[] out;

	//	free delta
	for (int i = 0; i < numl; i++) delete[] delta[i];
	delete[] delta;

	//	free w
	for (int i = 1; i < numl; i++)
		for (int j = 0; j < lsize[i]; j++) delete[] w[i][j];
	for (int i = 1; i < numl; i++) delete[] w[i];
	delete[] w;

	//	free d
	for (int i = 1; i < numl; i++)
		for (int j = 0; j < lsize[i]; j++) delete[] d[i][j];
	for (int i = 1; i < numl; i++) delete[] d[i];
	delete[] d;

	//	free g
	for (int i = 1; i < numl; i++)
		for (int j = 0; j < lsize[i]; j++) delete[] g[i][j];
	for (int i = 1; i < numl; i++) delete[] g[i];
	delete[] g;

	//	free gSign
	for (int i = 1; i < numl; i++)
		for (int j = 0; j < lsize[i]; j++) delete[] gSign[i][j];
	for (int i = 1; i < numl; i++) delete[] gSign[i];
	delete[] gSign;

	//	free layer info
	delete[] lsize;
}

//	Neuron activation function ---------------------------------------------------------------+
double NN::af(double in)
{
	if (AFT == 1)
	{
		//	tanh
		double tmp = 2.0 * in;
		if (tmp >= 0)
		{
			tmp = exp(-tmp);
			return ((1.0 - tmp) / (1.0 + tmp));
		}
		else
		{
			tmp = exp(tmp);
			return ((tmp - 1.0) / (tmp + 1.0));
		}
	}
	else if (AFT == 2)
	{
		//	x/(1+|x|)
		return (in / (1.0 + fabs(in)));
	}
	else
	{
		//	sigmoid
		if (in >= 0) return (1.0 / (1.0 + exp(-in)));
		else
		{
			double tmp = exp(in);
			return (tmp / (tmp + 1.0));
		}
	}
}

//	Derivative of activation function --------------------------------------------------------+
double NN::afDeriv(double out)
{
	if (AFT == 1)
	{
		//	tanh
		return (1 - out * out);
	}
	else if (AFT == 2)
	{
		//	rational x/(1+|x|)
		return (pow(1.0 - fabs(out), 2));
	}
	else
	{
		//	sigmoid
		return (out * (1.0 - out));
	}
}

//	Sign function ----------------------------------------------------------------------------+
int NN::sign(double val)
{
	if (val < 0.0) return -1;
	else if (val == 0.0) return 0;
	else return 1;
}

//	Return i'th output of the net ------------------------------------------------------------+
double NN::Out(int j) const
{
	return out[numl - 1][j];
}

//	Return weight ----------------------------------------------------------------------------+
double NN::Wt(int i, int j, int k) const
{
	return w[i][j][k];
}

//	Feedforward one set of input -------------------------------------------------------------+
void NN::ffwd(double* in)
{
	//	assign input data to the outputs of the 0th layer (i=0)
	for (int j = 0; j < lsize[0]; j++) out[0][j] = in[j];

	//	compute output of each neuron as a sum of its scaled inputs passed through activation func
	for (int i = 1; i < numl; i++)							// for each layer except input
		for (int j = 0; j < lsize[i]; j++)					// for each neuron in current layer
		{
			double sum = 0.0;
			for (int k = 0; k < lsize[i - 1]; k++)			// for each input of curr neuron excl bias
				sum += out[i - 1][k] * w[i][j][k];		// apply weights to inputs and add to sum
			sum += w[i][j][lsize[i - 1]];				// add bias
			if (i == numl - 1 && OAF == 0) out[i][j] = sum;	// apply activation function to all neurons
			else out[i][j] = af(sum);					// except in the output layer if OAF=0
		}
}

//	Compute new weights and MSE --------------------------------------------------------------+
char* NN::xprop(double** in, double** tgt, const int ntr, int nep, const double maxMSE)
{
	double MSE, prevMSE = 1.0e9;
	int ep;
	static char status[80];
	for (ep = 0; ep < nep; ep++)							// for each epoch
	{
		//	compute MSE and gradients using backpropagation of error
		MSE = 0.0;
		for (int s = 0; s < ntr; s++)						// for each training set
		{
			//	update output values for each neuron
			ffwd(in[s]);

			//	find deltas for each neuron in the output layer i=numl-1
			for (int j = 0; j < lsize[numl - 1]; j++)		// for each neuron in output layer
			{
				delta[numl - 1][j] = tgt[s][j] - out[numl - 1][j];
				MSE += pow(delta[numl - 1][j], 2);
				if (OAF == 1)
					delta[numl - 1][j] *= afDeriv(out[numl - 1][j]);
			}

			//	propagate deltas from output layer to hidden layers	
			for (int i = numl - 2; i > 0; i--)				// for each layer except input & output
				for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
				{
					double sum = 0.0;
					for (int k = 0; k < lsize[i + 1]; k++)	// for each neuron in later layer
						sum += delta[i + 1][k] * w[i + 1][k][j];
					delta[i][j] = afDeriv(out[i][j]) * sum;
				}

			//	compute gradients: dE/dw[i][j][k]=-delta[i][j]*out[i-1][k]
			for (int i = 1; i < numl; i++)					// for each layer except input
				for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
				{
					for (int k = 0; k <= lsize[i - 1]; k++)	// for each input of curr neuron incl bias
					{
						//	accumulate gradients for all training sets in each epoch
						if (s == 0) g[i][j][k] = 0.0;	// set gradients to 0 at start of each epoch
						if (k == lsize[i - 1])			// acc grad's of bias inputs
							g[i][j][k] -= delta[i][j];
						else						// acc gradients of non-bias inputs
							g[i][j][k] -= delta[i][j] * out[i - 1][k];
					}
				}
		}
		if (MSE < maxMSE)
		{
			sprintf_s(status, "Network trained in %u epochs with MSE %E", ep + 1, MSE);
			return(status);
		}

		//	compute new weights in batch mode
		for (int i = 1; i < numl; i++)					// for each layer except input
			for (int j = 0; j < lsize[i]; j++)			// for each neuron in current layer
			{
				for (int k = 0; k <= lsize[i - 1]; k++)	// for each input of current neuron incl bias
				{
					//	batch Rprop
					double prod = g[i][j][k] * gSign[i][j][k];
					if (prod > 0.0)		// previous weight step reduced error
					{
						d[i][j][k] = min(d[i][j][k] * plus, dmax);		// increase step
						gSign[i][j][k] = sign(g[i][j][k]);
						w[i][j][k] -= gSign[i][j][k] * d[i][j][k];
					}
					else if (prod < 0.0)	// previous weight step increased error
					{
						if (MSE > prevMSE)
							w[i][j][k] += gSign[i][j][k] * d[i][j][k];	// backtrack
						d[i][j][k] = max(d[i][j][k] * minus, dmin);		// reduce step
						gSign[i][j][k] = 0;
					}
					else				// typically only happens in the first epoch
					{
						gSign[i][j][k] = sign(g[i][j][k]);
						w[i][j][k] -= gSign[i][j][k] * d[i][j][k];
					}
				}
			}

		prevMSE = MSE;
	}
	if (ep == nep) sprintf_s(status, "Reached maximum number of epochs with MSE %E", MSE);
	return(status);
}

// =========================================== Train ==========================================
//2025.10.16 11:01 : 40.808	cannot find 'string BPNN64::Train(
// double&[],
// double&[],
// double&[],
// int,
// int,
// double&[],
// double&[],
// int,
// int&[],
// int,
// int,
// int,
// double)' in module 'BPNN64.dll'
#define STATUS_BUF_SZ 80
MT5_EXPFUNC wchar_t* __stdcall Train(
	const double* inpTrain,	// Input training data (2D data as 1D array, oldest first)
	const double* outTarget,// Output target data for training (2D data as 1D array, oldest first)
	double* outTrain,	// Output 1D array to hold net outputs from training
	int     ntr,		// # of training sets
	int     UEW,      // Use External Weights for initialization (1=use extInitWt, 0=use rnd)
	const double* extInitWt,// Input 1D array to hold 3D array of external initial weights
	double* trainedWt,// Output 1D array to hold 3D array of trained weights
	int     numLayers,// # of net layers including input, hidden and output
	const int* lSz,		// # of neurons in layers. lSz[0] is # of net inputs (nin)
	int     AFT,		// Type of neuron activation function (0:sigm, 1:tanh, 2:x/(1+x))
	int     OAF,		// 1 enables activation function for output layer neurons; 0 disables
	int     nep,		// Max # of training epochs
	double  maxMSE	// Max MSE; training stops once maxMSE is reached
)
{
	static wchar_t status[STATUS_BUF_SZ];
	//	Prepare input data -----------------------------------------------------------------------+
	int nin = lSz[0];
	int nout = lSz[numLayers - 1];
	// Create a 2D array to hold input training data
	double** trainData = new double* [ntr];
	for (int i = 0; i < ntr; i++) trainData[i] = new double[nin];
	for (int i = 0; i < ntr; i++)
		for (int j = 0; j < nin; j++) trainData[i][j] = inpTrain[i * nin + j];
	// Create a 2D array to hold output target data used for training
	double** targetData = new double* [ntr];
	for (int i = 0; i < ntr; i++) targetData[i] = new double[nout];
	for (int i = 0; i < ntr; i++)
		for (int j = 0; j < nout; j++) targetData[i][j] = outTarget[i * nout + j];

	// The input data is arranged as follows:
	//
	// trainData[i][j] = inpTrain[i*nin+j]
	//      j= 0...nin-1
	//            |
	// i=0     <inputs>
	// ...     <inputs>
	// i=ntr-1 <inputs> 
	//
	// targetData[i][j] = outTarget[i*nout+j]
	//      j= 0...nout-1
	//             |
	// i=0     <targets>
	// ...     <targets>
	// i=ntr-1 <targets> 

//	Create & train NN ------------------------------------------------------------------------+
	NN* bp = new NN(numLayers, lSz, AFT, OAF, UEW, extInitWt);
	swprintf_s(status, STATUS_BUF_SZ, (const wchar_t *)bp->xprop(trainData, targetData, ntr, nep, maxMSE));

	//	Save output data -------------------------------------------------------------------------+
	for (int i = 0; i < ntr; i++)
	{
		bp->ffwd(trainData[i]);
		for (int j = 0; j < nout; j++) outTrain[i * nout + j] = bp->Out(j);
	}
	int iw = 0;
	for (int i = 1; i < numLayers; i++)			// for each layer except input
		for (int j = 0; j < lSz[i]; j++)			// for each neuron in current layer
			for (int k = 0; k <= lSz[i - 1]; k++)	// for each input of current neuron including bias
				trainedWt[iw++] = bp->Wt(i, j, k);

	// The output data is arranged as follows:
	//
	// outTrain[i*nout+j]
	//      j= 0...nout-1
	//             |
	// i=0     <outputs>
	// ...     <outputs>
	// i=ntr-1 <outputs>  

//	Free up memory ---------------------------------------------------------------------------+
	bp->~NN();
	for (int i = 0; i < ntr; i++) delete[] trainData[i];
	delete[] trainData;
	for (int i = 0; i < ntr; i++) delete[] targetData[i];
	delete[] targetData;
	return(status);
}
// =========================================== Test ===========================================

MT5_EXPFUNC wchar_t* __stdcall Test(
	const double* inpTest,	// Input test data (2D data as 1D array, oldest first)
	double* outTest,	// Net outputs from testing
	const int     ntt,		// # of test sets
	const double* extInitWt,// Input 1D array to hold 3D array of external initial weights
	const int     numLayers,// # of net layers including input, hidden and output
	const int* lSz,		// # of neurons in layers. lSz[0] is # of net inputs (nin)
	const int     AFT,		// Type of neuron activation function (0:sigm, 1:tanh, 2:x/(1+x))
	const int     OAF		// 1 enables activation function for output layer neurons; 0 disables
)
{
	static wchar_t status[STATUS_BUF_SZ];
	//	Prepare input data -----------------------------------------------------------------------+
	int nin = lSz[0];
	int nout = lSz[numLayers - 1];
	double** testData = new double* [ntt];
	for (int i = 0; i < ntt; i++) testData[i] = new double[nin];
	for (int i = 0; i < ntt; i++)
		for (int j = 0; j < nin; j++) testData[i][j] = inpTest[i * nin + j];

	// The input data is arranged as follows:
	//
	// testData[i][j] = inpTest[i*nin+j]
	//      j= 0...nin-1
	//            |
	// i=0     <inputs>
	// ...     <inputs>
	// i=ntt-1 <inputs>
	//
	// <inputs> start with the oldest value first

//	Create & test NN -------------------------------------------------------------------------+
	NN* bp = new NN(numLayers, lSz, AFT, OAF, 1, extInitWt);
	for (int i = 0; i < ntt; i++)
	{
		bp->ffwd(testData[i]);
		for (int j = 0; j < nout; j++) outTest[i * nout + j] = bp->Out(j);
	}
	// The output data is arranged as follows:
	//
	// outTest[i*nout+j]
	//      j= 0...nout-1
	//             |
	// i=0     <outputs>
	// ...     <outputs>
	// i=ntt-1 <outputs> 

//	Free up memory ---------------------------------------------------------------------------+
	bp->~NN();
	for (int i = 0; i < ntt; i++) delete[] testData[i];
	delete[] testData;
	return(status);
}

//MT5_EXPFUNC wchar_t* __stdcall
MT5_EXPFUNC wchar_t* __stdcall GetStringValue(wchar_t *spar)

{
	static wchar_t status[STATUS_BUF_SZ];

	swprintf_s(status, STATUS_BUF_SZ, L"%s %s", spar, (wchar_t*)L" it ...");

	return(status);

}
MT5_EXPFUNC int __stdcall SetIntArrayValValue(const int *constLSz, const int constLSzSize,  int *lSz, const int lSzSize, int val)

{
	if (lSzSize < 1)
		return 0;
	lSz[0] = val;
	return(lSz[0]);

}

MT5_EXPFUNC wchar_t* __stdcall TrainParamImportTest(
	const double* inpTrain,	// Input training data (2D data as 1D array, oldest first)
	const double* outTarget,// Output target data for training (2D data as 1D array, oldest first)
	double* outTrain,	// Output 1D array to hold net outputs from training
	int     ntr,		// # of training sets
	int     UEW,      // Use External Weights for initialization (1=use extInitWt, 0=use rnd)
	const double* extInitWt,// Input 1D array to hold 3D array of external initial weights
	double* trainedWt//,// Output 1D array to hold 3D array of trained weights
	//int     numLayers,// # of net layers including input, hidden and output
	//const int* lSz,		// # of neurons in layers. lSz[0] is # of net inputs (nin)
	//int     AFT,		// Type of neuron activation function (0:sigm, 1:tanh, 2:x/(1+x))
	//int     OAF,		// 1 enables activation function for output layer neurons; 0 disables
	//int     nep,		// Max # of training epochs
	//double  maxMSE	// Max MSE; training stops once maxMSE is reached

)
{
	return((wchar_t *)L"Gotcha");
}