//+------------------------------------------------------------------+
//|                                                         Font.mq5 |
//|                        Copyright 2017, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2016, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property script_show_inputs
#resource "\\Files\\heydings-icons.ttf"

#include <Canvas\Canvas.mqh>
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
input string InpMessage="Hello world!";   // message
input uint   InpSeconds=10;               // time in seconds
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
   ChartSetInteger(0,CHART_SHOW,0);
  
   CCanvas graph;
   
   graph.CreateBitmapLabel(0,0,"FONT",10,30,1320,200,COLOR_FORMAT_ARGB_NORMALIZE);
   graph.FontSet("::Files\\heydings-icons.ttf",-240);
   
   uint timeout=GetTickCount()+InpSeconds*1000;
   
   while(!IsStopped())
     {
      graph.Erase(0);
      graph.TextOut(0,0,"4" + " ("+string((timeout-GetTickCount())/1000)+")",XRGB(255,255,255));
      graph.Update();
      
      if(GetTickCount()>timeout)
         break;
     }
     
   graph.Destroy();
   
   ChartSetInteger(0,CHART_SHOW,1);
  }
//+------------------------------------------------------------------+
