
bool IsTradeAllowed(void)
{
  return (bool)TerminalInfoInteger(TERMINAL_TRADE_ALLOWED) && (bool)MQLInfoInteger(MQL_TRADE_ALLOWED);
}

bool IsTradeAllowed(const string symbol, datetime time)
{
  const ulong day = 60 * 60 * 24;
  const uint session = 0;
  datetime from, to;
  if(SymbolInfoSessionTrade(symbol, (ENUM_DAY_OF_WEEK)TimeDayOfWeek(time), session, from, to))
  {
    return (((ulong)time % day) >= ((ulong)from % day) && ((ulong)time % day) <= ((ulong)to % day));
  }
  return false;
}

bool IsTradeContextBusy(void)
{
  return false;
}

bool RefreshRates(void)
{
  return true;
}
