#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>

long TICKS=1;       // кол-во тиков в баре
long BARS=1024;     // кол-во генерируемых баров
void generator();
void
Usage(FILE *f)
{
	fprintf(f,"Usage: generator BARS TICKS\n");
}
int main(int argc,char *argv[])
{
	// первый аргумент - кол-во генерируемых баров
	if (argc>1) {
		char *eos;
		long value=strtol(argv[1],&eos,0);
		if (eos==NULL || eos[0]!=0 || errno==ERANGE || value<1) {
			fprintf(stderr,"bad value for BARS : %s\n",argv[1]);
			return EXIT_FAILURE;
		}
		BARS=value;
	}
	// второй аргуемент - кол-во тиков в баре
	if (argc>2) {
		char *eos;
		long value=strtol(argv[2],&eos,0);
		if (eos==NULL || eos[0]!=0 || errno==ERANGE || value<1) {
			fprintf(stderr,"bad value for TICKS : %s\n",argv[2]);
			return EXIT_FAILURE;
		}
		TICKS=value;
	}
	// больше 2-х пока быть не может
	if (argc>3) {
		Usage(stderr);
		return EXIT_FAILURE;
	}
	srand(time(NULL));
	generator();
	return 0;
}
enum OHLC {
	OPEN,
	HIGH,
	LOW,
	CLOSE
};
void
generator()
{
	long R1=rand();		// случ.значение от предыдущео шага
	long ohlc[CLOSE+1]={0};
	for(int bar=0;bar<BARS;bar++) {
        ohlc[OPEN]=ohlc[HIGH]=ohlc[LOW]=ohlc[CLOSE];
		for(int tick=0;tick<TICKS;tick++) {
			long R0;
			// ЭМУЛИРУЕМ ПОСТУПЛЕНИЕ ЗАЯВКИ
			// получаем случ.число не равное пред. и не равное 0
			do {
				R0=rand(); // для простоты - равномерное, ближе к реалиям нормальное 
			} while(R0==R1 || R0==0);
			// "ПЕРВАЯ РУКА", первичная обработка заявки
			// вот тут можно добавить "скрытый манипулятор"
			// который может убавить/добавить к R0 от своих предпочтений
            // 
			// ЭМУЛЯЦИЯ ТОРГОВ - из объёмов заявок получаем движение цены 
			// сравниваем с пред
            if (R0<R1) {
                ohlc[CLOSE]--;
            } else {
                /* R0>R1 */
                ohlc[CLOSE]++;
            }
            
			// контроль high/low
			if (ohlc[CLOSE]>ohlc[HIGH]) ohlc[HIGH]=ohlc[CLOSE];
			if (ohlc[CLOSE]<ohlc[LOW]) ohlc[LOW]=ohlc[CLOSE];
			// сохраняем R для след.шага
			R1=R0;
		}
		// получена новая цена - выводим
		printf("%ld  %ld  %ld  %ld\n",ohlc[0],ohlc[1],ohlc[2],ohlc[3]);
	}
}

