﻿#include <Trade\Trade.mqh>

// الإعدادات
input double Risk_Percent = 1.0;   // نسبة المخاطرة من الحساب
input int    Target_RR    = 2;     // هدف الربح ضعف الستوب

CTrade trade;
bool   is_done = false;
int    last_day = -1;

void OnTick()
{
   MqlDateTime dt;
   TimeCurrent(dt);

   // إعادة ضبط البوت تلقائياً عند بداية يوم جديد
   if(dt.day != last_day) 
   {
      is_done = false;
      last_day = dt.day;
   }

   // إذا دخل صفقة اليوم، يتوقف تماماً
   if(is_done) return;
   
   // منع فتح أكثر من صفقة في نفس الوقت للرمز الحالي
   if(PositionsTotal() > 0) 
   {
      for(int i=0; i<PositionsTotal(); i++)
         if(PositionGetSymbol(i) == _Symbol) return;
   }

   // استراتيجية فنية: كسر قمة/قاع الشمعة السابقة (H1)
   double high_prev = iHigh(_Symbol, PERIOD_H1, 1);
   double low_prev  = iLow(_Symbol, PERIOD_H1, 1);
   double Ask = SymbolInfoDouble(_Symbol, SYMBOL_ASK);
   double Bid = SymbolInfoDouble(_Symbol, SYMBOL_BID);

   // شرط الشراء: تجاوز قمة الشمعة الماضية
   if(Ask > high_prev)
   {
      double sl = low_prev; // الستوب عند القاع السابق
      double tp = Ask + (Ask - sl) * Target_RR;
      double lot = CalculateLot(Ask - sl);
      
      if(trade.Buy(lot, _Symbol, Ask, sl, tp)) is_done = true;
   }
   // شرط البيع: كسر قاع الشمعة الماضية
   else if(Bid < low_prev)
   {
      double sl = high_prev; // الستوب عند القمة السابقة
      double tp = Bid - (sl - Bid) * Target_RR;
      double lot = CalculateLot(sl - Bid);
      
      if(trade.Sell(lot, _Symbol, Bid, sl, tp)) is_done = true;
   }
}

double CalculateLot(double sl_dist) 
{
   double risk = AccountInfoDouble(ACCOUNT_BALANCE) * (Risk_Percent / 100.0);
   double tick = SymbolInfoDouble(_Symbol, SYMBOL_TRADE_TICK_VALUE);
   double lot = risk / (sl_dist / _Point * tick);
   return NormalizeDouble(MathMax(0.01, lot), 2);
}