
#property copyright "Copyright  2012, forex4live.com"
#property link      "http://www.forex4live.com/"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 Black
#property indicator_color2 DodgerBlue
#property indicator_color3 White
#property indicator_maximum 3
#property indicator_minimum -3

extern string Notealerts     = "-----Alert Settings-----";
extern bool   MsgAlerts      = TRUE;
extern bool   SoundAlerts    = TRUE;
extern string SoundAlertFile = "alert.wave";
extern bool   eMailAlerts    = FALSE;
       int    G_bars_104;
extern int    BarsCount      = 17;
       
       double G_ibuf_112[];
       double G_ibuf_116[];
       double G_ibuf_120[];

// E37F0136AA3FFAF149B351F6A4C948E9
int init()
 {
  string Lsa_0[256];
  
  for (int index_4 = 0; index_4 < 256; index_4++)
   Lsa_0[index_4] = CharToStr(index_4);
  
  int str2int_8 = StrToInteger(Lsa_0[67] + Lsa_0[111] + Lsa_0[112] + Lsa_0[121] + Lsa_0[32] + Lsa_0[82]  + Lsa_0[105] + Lsa_0[103] + Lsa_0[104] + Lsa_0[116] +
                               Lsa_0[32] + Lsa_0[169] + Lsa_0[32]  + Lsa_0[75]  + Lsa_0[97] + Lsa_0[122] + Lsa_0[97]  + Lsa_0[111] + Lsa_0[111] + Lsa_0[32]  +
                               Lsa_0[50] + Lsa_0[48]  + Lsa_0[49]  + Lsa_0[49]  + Lsa_0[32]);
  
  SetIndexStyle     (0, DRAW_LINE);
  SetIndexStyle     (1, DRAW_LINE);
  SetIndexStyle     (2, DRAW_LINE);
  IndicatorDigits   (Digits + 0);
  SetIndexBuffer    (0, G_ibuf_112);
  SetIndexBuffer    (1, G_ibuf_116);
  SetIndexBuffer    (2, G_ibuf_120);
  IndicatorShortName("FL23");
  SetIndexLabel     (1, NULL);
  SetIndexLabel     (2, NULL);
  
  return(0);
 }

// EA2B2676C28C0DB26D39331A336C6B92
int start()
 {
  double Ld_0;
  double Ld_8;
  double Ld_16;
  
  string Ls_104;
  string Ls_112;
  string Ls_120;
  
  int Li_24 = IndicatorCounted();
  
  double Ld_28        = 0;
  double Ld_36        = 0;
  double Ld_unused_44 = 0;
  double Ld_unused_52 = 0;
  double Ld_60        = 0;
  double Ld_unused_68 = 0;
  double low_76       = 0;
  double high_84      = 0;
  
  if (Li_24 > 0)
   Li_24--;
  
  int Li_92 = Bars - Li_24;
  
  for (int Li_96 = 0; Li_96 < Li_92; Li_96++)
   {
    high_84 = High[iHighest(NULL, 0, MODE_HIGH, BarsCount, Li_96)];
    low_76  = Low [iLowest (NULL, 0, MODE_LOW,  BarsCount, Li_96)];
    
    Ld_16 = (High[Li_96] + Low[Li_96]) / 2.0;
    Ld_28 = 0.66 * ((Ld_16 - low_76) / (high_84 - low_76) - 0.5) + 0.67 * Ld_36;
    Ld_28 = MathMin(MathMax(Ld_28, -0.999), 0.999);
    
    G_ibuf_112[Li_96] = MathLog((Ld_28 + 1.0) / (1 - Ld_28)) / 2.0 + Ld_60 / 2.0;
    
    Ld_36 = Ld_28;
    Ld_60 = G_ibuf_112[Li_96];
   }
  
  bool Li_100 = TRUE;
  
  for (Li_96 = Li_92 - 2; Li_96 >= 0; Li_96--)
   {
    Ld_8 = G_ibuf_112[Li_96 + 1];
    Ld_0 = G_ibuf_112[Li_96 + 2];
    
    if ((Ld_8 < 0.0 && Ld_0 > 0.0) ||
         Ld_8 < 0.0)
     {
      Li_100 = FALSE;
      
      if (Ld_8 < 0.0 && Ld_0 > 0.0)
       {
        Ls_104 = Symbol() + ", TF:" + f0_1(Period());
        Ls_112 = Ls_104 + ", Trend Is Now Down, value: " + Ld_8;
        Ls_120 = Ls_112 + " @ " + TimeToStr(TimeLocal(), TIME_SECONDS);
        
        if (Bars > G_bars_104)
         {
          G_bars_104 = Bars;
          f0_0(Ls_120, Ls_112);
         }
       }
     }
    
    if ((Ld_8 > 0.0 && Ld_0 < 0.0) ||
         Ld_8 > 0.0)
     {
      Li_100 = TRUE;
      
      if (Ld_8 > 0.0 && Ld_0 < 0.0)
       {
        Ls_104 = Symbol() + ", TF:" + f0_1(Period());
        Ls_112 = Ls_104 + ", Trend Is Now Up, value: " + Ld_8;
        Ls_120 = Ls_112 + " @ " + TimeToStr(TimeLocal(), TIME_SECONDS);
        
        if (Bars > G_bars_104)
         {
          G_bars_104 = Bars;
          f0_0(Ls_120, Ls_112);
         }
       }
     }
    
    if (!Li_100)
     {
      G_ibuf_120[Li_96] = Ld_8;
      G_ibuf_116[Li_96] = 0.0;
     }
    else
     {
      G_ibuf_116[Li_96] = Ld_8;
      G_ibuf_120[Li_96] = 0.0;
     }
   }
  
  return(0);
 }

// 3BEBDBF39866D2F719D187268C69411D
void f0_0(string As_0, string As_8)
 {
  if (MsgAlerts)
   Alert(As_0);
  
  if (SoundAlerts)
   PlaySound(SoundAlertFile);
  
  if (eMailAlerts)
   SendMail(As_8, As_0);
 }

// 3F2ED24E00B8A9842F127B337A156D20
string f0_1(int Ai_0)
 {
  switch (Ai_0)
   {
    case 1     : return("M1");
    case 5     : return("M5");
    case 15    : return("M15");
    case 30    : return("M30");
    case 60    : return("H1");
    case 240   : return("H4");
    case 1440  : return("D1");
    case 10080 : return("W1");
    case 43200 : return("MN1");
   }
  
  return(Period());
 }
