﻿using System;
using System.Collections.Generic;
using System.Linq;
using Websocket.Client.Exceptions;

namespace Websocket.Client.Validations
{
	internal static class Validations
	{
		public static void ValidateInput(string value, string name)
		{
			if (string.IsNullOrEmpty(value))
			{
				throw new WebsocketBadInputException("Input string parameter '" + name + "' is null or empty. Please correct it.");
			}
		}

		public static void ValidateInput<T>(T value, string name)
		{
			if (object.Equals(value, default(T)))
			{
				throw new WebsocketBadInputException("Input parameter '" + name + "' is null. Please correct it.");
			}
		}

		public static void ValidateInputCollection<T>(IEnumerable<T> collection, string name)
		{
			Validations.ValidateInput<IEnumerable<T>>(collection, name);
			if (!collection.Any<T>())
			{
				throw new WebsocketBadInputException("Input collection '" + name + "' is empty. Please correct it.");
			}
		}

		public static void ValidateInput(int value, string name, int minValue = -2147483648, int maxValue = 2147483647)
		{
			if (value < minValue)
			{
				throw new WebsocketBadInputException(string.Format("Input parameter '{0}' is lower than {1}. Please correct it.", name, minValue));
			}
			if (value > maxValue)
			{
				throw new WebsocketBadInputException(string.Format("Input parameter '{0}' is higher than {1}. Please correct it.", name, maxValue));
			}
		}

		public static void ValidateInput(long value, string name, long minValue = -9223372036854775808L, long maxValue = 9223372036854775807L)
		{
			if (value < minValue)
			{
				throw new WebsocketBadInputException(string.Format("Input parameter '{0}' is lower than {1}. Please correct it.", name, minValue));
			}
			if (value > maxValue)
			{
				throw new WebsocketBadInputException(string.Format("Input parameter '{0}' is higher than {1}. Please correct it.", name, maxValue));
			}
		}

		public static void ValidateInput(double value, string name, double minValue = -1.7976931348623157E+308, double maxValue = 1.7976931348623157E+308)
		{
			if (value < minValue)
			{
				throw new WebsocketBadInputException(string.Format("Input parameter '{0}' is lower than {1}. Please correct it.", name, minValue));
			}
			if (value > maxValue)
			{
				throw new WebsocketBadInputException(string.Format("Input parameter '{0}' is higher than {1}. Please correct it.", name, maxValue));
			}
		}
	}
}
