﻿using System;
using System.Net.WebSockets;

namespace Websocket.Client
{
	public class ResponseMessage
	{
		private ResponseMessage(byte[] binary, string text, WebSocketMessageType messageType)
		{
			this.Binary = binary;
			this.Text = text;
			this.MessageType = messageType;
		}

		public string Text { get; }

		public byte[] Binary { get; }

		public WebSocketMessageType MessageType { get; }

		public override string ToString()
		{
			if (this.MessageType == WebSocketMessageType.Text)
			{
				return this.Text;
			}
			string text = "Type binary, length: {0}";
			byte[] binary = this.Binary;
			return string.Format(text, (binary != null) ? new int?(binary.Length) : null);
		}

		public static ResponseMessage TextMessage(string data)
		{
			return new ResponseMessage(null, data, WebSocketMessageType.Text);
		}

		public static ResponseMessage BinaryMessage(byte[] data)
		{
			return new ResponseMessage(data, null, WebSocketMessageType.Binary);
		}
	}
}
