﻿using System;

namespace Websocket.Client.Logging.LogProviders
{
	internal static class TraceEventTypeValues
	{
		static TraceEventTypeValues()
		{
			if (TraceEventTypeValues.Type == null)
			{
				return;
			}
			TraceEventTypeValues.Verbose = (int)Enum.Parse(TraceEventTypeValues.Type, "Verbose", false);
			TraceEventTypeValues.Information = (int)Enum.Parse(TraceEventTypeValues.Type, "Information", false);
			TraceEventTypeValues.Warning = (int)Enum.Parse(TraceEventTypeValues.Type, "Warning", false);
			TraceEventTypeValues.Error = (int)Enum.Parse(TraceEventTypeValues.Type, "Error", false);
			TraceEventTypeValues.Critical = (int)Enum.Parse(TraceEventTypeValues.Type, "Critical", false);
		}

		internal static readonly Type Type = typeof(Uri).Assembly.GetType("System.Diagnostics.TraceEventType");

		internal static readonly int Verbose;

		internal static readonly int Information;

		internal static readonly int Warning;

		internal static readonly int Error;

		internal static readonly int Critical;
	}
}
