﻿using System;

namespace Websocket.Client.Logging.LogProviders
{
	internal class DisposableAction : IDisposable
	{
		public DisposableAction(Action onDispose = null)
		{
			this._onDispose = onDispose;
		}

		public void Dispose()
		{
			if (this._onDispose != null)
			{
				this._onDispose();
			}
		}

		private readonly Action _onDispose;
	}
}
