﻿using System;
using System.Net.WebSockets;

namespace Websocket.Client
{
	public class DisconnectionInfo
	{
		public DisconnectionInfo(DisconnectionType type, WebSocketCloseStatus? closeStatus, string closeStatusDescription, string subProtocol, Exception exception)
		{
			this.Type = type;
			this.CloseStatus = closeStatus;
			this.CloseStatusDescription = closeStatusDescription;
			this.SubProtocol = subProtocol;
			this.Exception = exception;
		}

		public DisconnectionType Type { get; }

		public WebSocketCloseStatus? CloseStatus { get; }

		public string CloseStatusDescription { get; }

		public string SubProtocol { get; }

		public Exception Exception { get; }

		public bool CancelReconnection { get; set; }

		public bool CancelClosing { get; set; }

		public static DisconnectionInfo Create(DisconnectionType type, WebSocket client, Exception exception)
		{
			return new DisconnectionInfo(type, (client != null) ? client.CloseStatus : null, (client != null) ? client.CloseStatusDescription : null, (client != null) ? client.SubProtocol : null, exception);
		}
	}
}
