﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;

namespace Replikanto.Util
{
	public class StrategyFiles
	{
		static StrategyFiles()
		{
			object obj = StrategyFiles.object_0;
			bool flag = false;
			try
			{
				Delegate41.smethod_0(obj, ref flag, Delegate41.delegate41_0);
				if (StrategyFiles.fileSystemWatcher_0 == null)
				{
					try
					{
						StrategyFiles.smethod_0();
						FileSystemWatcher fileSystemWatcher = new FileSystemWatcher();
						Delegate571.smethod_0(fileSystemWatcher, StrategyFiles.string_0, Delegate571.delegate571_0);
						Delegate572.smethod_0(fileSystemWatcher, "*.xml", Delegate572.delegate572_0);
						StrategyFiles.fileSystemWatcher_0 = fileSystemWatcher;
						Delegate573.smethod_0(StrategyFiles.fileSystemWatcher_0, new RenamedEventHandler(StrategyFiles.smethod_1), Delegate573.delegate573_0);
						Delegate574.smethod_0(StrategyFiles.fileSystemWatcher_0, new FileSystemEventHandler(StrategyFiles.smethod_2), Delegate574.delegate574_0);
						Delegate575.smethod_0(StrategyFiles.fileSystemWatcher_0, new FileSystemEventHandler(StrategyFiles.smethod_3), Delegate575.delegate575_0);
						Delegate576.smethod_0(StrategyFiles.fileSystemWatcher_0, true, Delegate576.delegate576_0);
						Delegate577.smethod_0(StrategyFiles.fileSystemWatcher_0, false, Delegate577.delegate577_0);
					}
					catch (Exception ex)
					{
						Delegate34.smethod_0(Delegate32.smethod_0("Strategy changed {0}", ex, Delegate32.delegate32_0), 3, Delegate34.delegate34_0);
					}
				}
			}
			finally
			{
				if (flag)
				{
					Delegate59.smethod_0(obj, Delegate59.delegate59_0);
				}
			}
		}

		private static void smethod_0()
		{
			FileInfo[] array = Delegate578.smethod_0(new DirectoryInfo(StrategyFiles.string_0), "*.xml", Delegate578.delegate578_0);
			for (int i = 0; i < array.Length; i++)
			{
				string text = Delegate580.smethod_0(Delegate579.smethod_0(array[i], Delegate579.delegate579_0), Delegate580.delegate580_0);
				if (!StrategyFiles.hashSet_0.Add(text))
				{
					Delegate34.smethod_0(Delegate51.smethod_0("Error on adding strategy name ", text, " to memory", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
				}
			}
		}

		private static void smethod_1(object object_1, object object_2)
		{
			try
			{
				StrategyFiles.hashSet_0.Add(Delegate580.smethod_0(Delegate581.smethod_0(object_2, Delegate581.delegate581_0), Delegate580.delegate580_0));
				StrategyFiles.hashSet_0.Remove(Delegate580.smethod_0(Delegate582.smethod_0(object_2, Delegate582.delegate582_0), Delegate580.delegate580_0));
			}
			catch (Exception ex)
			{
				Delegate34.smethod_0(Delegate50.smethod_0("Error replacing the old Strategy Name {0} to new {1} {2}", Delegate580.smethod_0(Delegate582.smethod_0(object_2, Delegate582.delegate582_0), Delegate580.delegate580_0), Delegate580.smethod_0(Delegate581.smethod_0(object_2, Delegate581.delegate581_0), Delegate580.delegate580_0), ex, Delegate50.delegate50_0), 3, Delegate34.delegate34_0);
			}
		}

		private static void smethod_2(object object_1, object object_2)
		{
			try
			{
				StrategyFiles.hashSet_0.Add(Delegate580.smethod_0(Delegate581.smethod_0(object_2, Delegate581.delegate581_0), Delegate580.delegate580_0));
			}
			catch (Exception ex)
			{
				Delegate34.smethod_0(Delegate82.smethod_0("Error creating the Strategy Name {0} {1}", Delegate580.smethod_0(Delegate581.smethod_0(object_2, Delegate581.delegate581_0), Delegate580.delegate580_0), ex, Delegate82.delegate82_0), 3, Delegate34.delegate34_0);
			}
		}

		private static void smethod_3(object object_1, object object_2)
		{
			try
			{
				StrategyFiles.hashSet_0.Remove(Delegate580.smethod_0(Delegate581.smethod_0(object_2, Delegate581.delegate581_0), Delegate580.delegate580_0));
			}
			catch (Exception ex)
			{
				Delegate34.smethod_0(Delegate82.smethod_0("Error deleting the Strategy Name {0} {1}", Delegate580.smethod_0(Delegate581.smethod_0(object_2, Delegate581.delegate581_0), Delegate580.delegate580_0), ex, Delegate82.delegate82_0), 3, Delegate34.delegate34_0);
			}
		}

		public static bool HasStrategy(string strategy)
		{
			return StrategyFiles.hashSet_0.Contains(strategy);
		}

		[Conditional("Debug")]
		private static void smethod_4(object object_1)
		{
			Delegate83.smethod_0(Delegate82.smethod_0("StrategyFiles - {0:yyyy-MM-dd HH:mm:ss.fff} - {1}", Delegate81.smethod_0(Delegate81.delegate81_0), object_1, Delegate82.delegate82_0), 0, Delegate83.delegate83_0);
		}

		internal static void smethod_5()
		{
		}

		internal static void smethod_6()
		{
		}

		internal static void smethod_7()
		{
		}

		internal static object smethod_8(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static void smethod_9()
		{
			StrategyFiles.smethod_0();
		}

		private static readonly string string_0 = Delegate33.smethod_0(Delegate87.smethod_0(Delegate87.delegate87_0), "templates\\AtmStrategy\\", Delegate33.delegate33_0);

		private static readonly object object_0 = new object();

		private static readonly FileSystemWatcher fileSystemWatcher_0;

		private static readonly HashSet<string> hashSet_0 = new HashSet<string>();
	}
}
