﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using Newtonsoft.Json;
using NinjaTrader.Cbi;

namespace Replikanto.Util
{
	public class ServerStrategy : IEquatable<ServerStrategy>
	{
		[JsonProperty(PropertyName = "stopOrders")]
		internal CompositeID[] StopOrders { get; set; } = new CompositeID[0];

		[JsonProperty(PropertyName = "targetOrders")]
		internal CompositeID[] TargetOrders { get; set; } = new CompositeID[0];

		internal bool AddOrder(ReplikantoOrder order, bool isTradingView = false)
		{
			if (!order.IsStopLimit && !order.IsStopMarket && !order.IsSimulatedStop)
			{
				return order.IsLimit && this.method_1(order, isTradingView);
			}
			return this.method_0(order, isTradingView);
		}

		internal void InsertOrder(int bracketIndex, ReplikantoOrder order)
		{
			try
			{
				if (!order.IsStopLimit && !order.IsStopMarket && !order.IsSimulatedStop)
				{
					if (order.IsLimit)
					{
						if (bracketIndex >= this.TargetOrders.Length)
						{
							CompositeID[] targetOrders = this.TargetOrders;
							Array.Resize<CompositeID>(ref targetOrders, bracketIndex + 1);
							this.TargetOrders = targetOrders;
						}
						this.TargetOrders[bracketIndex] = order.GetCompositeID();
					}
				}
				else
				{
					if (bracketIndex >= this.StopOrders.Length)
					{
						CompositeID[] stopOrders = this.StopOrders;
						Array.Resize<CompositeID>(ref stopOrders, bracketIndex + 1);
						this.StopOrders = stopOrders;
					}
					this.StopOrders[bracketIndex] = order.GetCompositeID();
				}
			}
			catch (Exception)
			{
			}
		}

		private bool method_0(ReplikantoOrder replikantoOrder_0, bool bool_0 = false)
		{
			ServerStrategy.<>c__DisplayClass10_0 CS$<>8__locals1 = new ServerStrategy.<>c__DisplayClass10_0();
			CS$<>8__locals1.replikantoOrder_0 = replikantoOrder_0;
			if (!this.StopOrders.Any(new Func<CompositeID, bool>(CS$<>8__locals1.method_0)))
			{
				this.StopOrders = this.StopOrders.Append(CS$<>8__locals1.replikantoOrder_0.GetCompositeID()).ToArray<CompositeID>();
				if (this.StopOrders.Length == 1 && this.TargetOrders.Length == 0 && !bool_0)
				{
					this.TargetOrders = this.TargetOrders.Append(CompositeID.Empty()).ToArray<CompositeID>();
				}
				if (this.StopOrders.Length - this.TargetOrders.Length == 1 && !bool_0)
				{
					this.TargetOrders = this.TargetOrders.Append(CompositeID.Empty()).ToArray<CompositeID>();
				}
				return true;
			}
			return false;
		}

		private bool method_1(ReplikantoOrder replikantoOrder_0, bool bool_0 = false)
		{
			ServerStrategy.<>c__DisplayClass11_0 CS$<>8__locals1 = new ServerStrategy.<>c__DisplayClass11_0();
			CS$<>8__locals1.replikantoOrder_0 = replikantoOrder_0;
			if (!this.TargetOrders.Any(new Func<CompositeID, bool>(CS$<>8__locals1.method_0)))
			{
				this.TargetOrders = this.TargetOrders.Append(CS$<>8__locals1.replikantoOrder_0.GetCompositeID()).ToArray<CompositeID>();
				if (this.TargetOrders.Length - this.StopOrders.Length == 2 && !bool_0)
				{
					this.StopOrders = this.StopOrders.Append(CompositeID.Empty()).ToArray<CompositeID>();
				}
				return true;
			}
			return false;
		}

		internal CompositeID GetOpositOrder(Order order)
		{
			if (order != null)
			{
				if (!Delegate416.smethod_0(order, Delegate416.delegate416_0) && !Delegate417.smethod_0(order, Delegate417.delegate417_0) && !Delegate418.smethod_0(order, Delegate418.delegate418_0))
				{
					if (Delegate419.smethod_0(order, Delegate419.delegate419_0))
					{
						try
						{
							int bracketIndex = this.GetBracketIndex(order);
							if (bracketIndex < 0)
							{
								return null;
							}
							return this.StopOrders[bracketIndex];
						}
						catch (Exception)
						{
							return null;
						}
					}
					return null;
				}
				CompositeID compositeID;
				try
				{
					int bracketIndex2 = this.GetBracketIndex(order);
					if (bracketIndex2 < 0)
					{
						compositeID = null;
					}
					else
					{
						compositeID = this.TargetOrders[bracketIndex2];
					}
				}
				catch (Exception)
				{
					compositeID = null;
				}
				return compositeID;
			}
			return null;
		}

		internal CompositeID GetOpositOrder(ReplikantoOrder order)
		{
			if (order == null)
			{
				return null;
			}
			if (!order.IsStopLimit && !order.IsStopMarket && !order.IsSimulatedStop)
			{
				if (order.IsLimit)
				{
					try
					{
						return this.StopOrders[this.GetBracketIndex(order)];
					}
					catch (Exception)
					{
						return null;
					}
				}
				return null;
			}
			CompositeID compositeID;
			try
			{
				compositeID = this.TargetOrders[this.GetBracketIndex(order)];
			}
			catch (Exception)
			{
				compositeID = null;
			}
			return compositeID;
		}

		internal CompositeID GetStopOrder(int i)
		{
			if (i >= this.StopOrders.Length)
			{
				return null;
			}
			return this.StopOrders[i];
		}

		internal CompositeID GetTargetOrder(int i)
		{
			if (i >= this.TargetOrders.Length)
			{
				return null;
			}
			return this.TargetOrders[i];
		}

		internal bool Contains(Order order)
		{
			ServerStrategy.<>c__DisplayClass16_0 CS$<>8__locals1 = new ServerStrategy.<>c__DisplayClass16_0();
			CS$<>8__locals1.order_0 = order;
			return CS$<>8__locals1.order_0 != null && (this.StopOrders.Any(new Func<CompositeID, bool>(CS$<>8__locals1.method_0)) || this.TargetOrders.Any(new Func<CompositeID, bool>(CS$<>8__locals1.method_1)));
		}

		internal int GetBracketIndex(Order order)
		{
			ServerStrategy.<>c__DisplayClass17_0 CS$<>8__locals1 = new ServerStrategy.<>c__DisplayClass17_0();
			CS$<>8__locals1.order_0 = order;
			try
			{
				if (Delegate416.smethod_0(CS$<>8__locals1.order_0, Delegate416.delegate416_0) || Delegate417.smethod_0(CS$<>8__locals1.order_0, Delegate417.delegate417_0) || Delegate418.smethod_0(CS$<>8__locals1.order_0, Delegate418.delegate418_0))
				{
					return Array.FindIndex<CompositeID>(this.StopOrders, new Predicate<CompositeID>(CS$<>8__locals1.method_0));
				}
				if (Delegate419.smethod_0(CS$<>8__locals1.order_0, Delegate419.delegate419_0))
				{
					return Array.FindIndex<CompositeID>(this.TargetOrders, new Predicate<CompositeID>(CS$<>8__locals1.method_1));
				}
			}
			catch (Exception)
			{
				return -1;
			}
			return -1;
		}

		internal int GetBracketIndex(ReplikantoOrder replikantoOrder)
		{
			ServerStrategy.<>c__DisplayClass18_0 CS$<>8__locals1 = new ServerStrategy.<>c__DisplayClass18_0();
			CS$<>8__locals1.replikantoOrder_0 = replikantoOrder;
			try
			{
				if (CS$<>8__locals1.replikantoOrder_0.IsStopLimit || CS$<>8__locals1.replikantoOrder_0.IsStopMarket || CS$<>8__locals1.replikantoOrder_0.IsSimulatedStop)
				{
					return Array.FindIndex<CompositeID>(this.StopOrders, new Predicate<CompositeID>(CS$<>8__locals1.method_0));
				}
				if (CS$<>8__locals1.replikantoOrder_0.IsLimit)
				{
					return Array.FindIndex<CompositeID>(this.TargetOrders, new Predicate<CompositeID>(CS$<>8__locals1.method_1));
				}
			}
			catch (Exception)
			{
				return -1;
			}
			return -1;
		}

		internal void Clear()
		{
			Delegate568.smethod_0(this.StopOrders, 0, this.StopOrders.Length, Delegate568.delegate568_0);
			Delegate568.smethod_0(this.TargetOrders, 0, this.StopOrders.Length, Delegate568.delegate568_0);
		}

		public override string ToString()
		{
			int num = this.TargetOrders.Length;
			int num2 = this.StopOrders.Length;
			StringBuilder stringBuilder = new StringBuilder();
			int i = 0;
			while (i < Delegate427.smethod_0(num, num2, Delegate427.delegate427_0))
			{
				CompositeID compositeID = null;
				CompositeID compositeID2 = null;
				try
				{
					compositeID = this.TargetOrders[i];
				}
				catch
				{
				}
				try
				{
					IL_004F:
					compositeID2 = this.StopOrders[i];
				}
				catch
				{
				}
				Delegate569.smethod_0(stringBuilder, Delegate50.smethod_0("[{0}] => Limit ({1}) Stop ({2}), ", i, (compositeID != null) ? new long?(compositeID.Id) : null, (compositeID2 != null) ? new long?(compositeID2.Id) : null, Delegate50.delegate50_0), Delegate569.delegate569_0);
				i++;
				continue;
				goto IL_004F;
			}
			return Delegate86.smethod_0(stringBuilder, Delegate86.delegate86_0);
		}

		internal bool IsTerminal(Account account)
		{
			if (account == null)
			{
				return true;
			}
			bool flag = true;
			if (this.TargetOrders.Count<CompositeID>() == 0 && this.StopOrders.Count<CompositeID>() == 0)
			{
				return false;
			}
			IEnumerator<CompositeID> enumerator = this.TargetOrders.Union(this.StopOrders).GetEnumerator();
			try
			{
				while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
				{
					CompositeID compositeID = enumerator.Current;
					if (!CompositeID.IsEmpty(compositeID))
					{
						Order order = ((account != null) ? Delegate570.smethod_0(account, compositeID.Id, Delegate570.delegate570_0) : null);
						if (order != null && !Delegate394.smethod_0(Delegate145.smethod_0(order, Delegate145.delegate145_0), Delegate394.vupglcLpc3))
						{
							flag = false;
							break;
						}
					}
				}
			}
			finally
			{
				if (enumerator != null)
				{
					Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
				}
			}
			if (flag)
			{
				enumerator = this.StopOrders.Union(this.StopOrders).GetEnumerator();
				try
				{
					while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
					{
						CompositeID compositeID2 = enumerator.Current;
						if (!CompositeID.IsEmpty(compositeID2))
						{
							Order order2 = ((account != null) ? Delegate570.smethod_0(account, compositeID2.Id, Delegate570.delegate570_0) : null);
							if (order2 != null && !Delegate394.smethod_0(Delegate145.smethod_0(order2, Delegate145.delegate145_0), Delegate394.vupglcLpc3))
							{
								flag = false;
								break;
							}
						}
					}
				}
				finally
				{
					if (enumerator != null)
					{
						Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
					}
				}
			}
			return flag;
		}

		[Conditional("Debug")]
		private void method_2(string string_0)
		{
			Delegate83.smethod_0(Delegate82.smethod_0("ServerStrategy - {0:yyyy-MM-dd HH:mm:ss.fff} - {1}", Delegate81.smethod_0(Delegate81.delegate81_0), string_0, Delegate82.delegate82_0), 0, Delegate83.delegate83_0);
		}

		public override bool Equals(object obj)
		{
			if (!(obj is ServerStrategy))
			{
				return false;
			}
			if (this == obj)
			{
				return true;
			}
			try
			{
				ServerStrategy serverStrategy = (ServerStrategy)obj;
				if (Delegate172.smethod_0(this.StopOrders, serverStrategy.StopOrders, Delegate172.delegate172_0) && Delegate172.smethod_0(this.TargetOrders, serverStrategy.TargetOrders, Delegate172.delegate172_0))
				{
					return true;
				}
			}
			catch (Exception)
			{
				return false;
			}
			return false;
		}

		public override int GetHashCode()
		{
			return Delegate192.smethod_0(this.StopOrders, Delegate192.delegate192_0) + Delegate192.smethod_0(this.TargetOrders, Delegate192.delegate192_0);
		}

		public bool Equals(ServerStrategy obj)
		{
			return obj != null && Delegate172.smethod_0(this.StopOrders, obj.StopOrders, Delegate172.delegate172_0) && Delegate172.smethod_0(this.TargetOrders, obj.TargetOrders, Delegate172.delegate172_0);
		}

		internal static bool smethod_0(object object_0)
		{
			return object_0.IsStopLimit;
		}

		internal static bool smethod_1(object object_0)
		{
			return object_0.IsStopMarket;
		}

		internal static bool smethod_2(object object_0)
		{
			return object_0.IsSimulatedStop;
		}

		internal static bool smethod_3(object object_0)
		{
			return object_0.IsLimit;
		}

		internal static object smethod_4(object object_0)
		{
			return object_0.GetCompositeID();
		}

		internal static object smethod_5()
		{
			return CompositeID.Empty();
		}

		internal static object smethod_6(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static bool smethod_7(object object_0)
		{
			return CompositeID.IsEmpty(object_0);
		}

		internal static long smethod_8(object object_0)
		{
			return object_0.Id;
		}

		internal static object smethod_9(object object_0)
		{
			return object_0.StopOrders;
		}

		internal static object smethod_10(object object_0)
		{
			return object_0.TargetOrders;
		}

		internal static void smethod_11()
		{
		}

		internal static void smethod_12()
		{
		}

		internal static void smethod_13()
		{
		}

		[CompilerGenerated]
		private CompositeID[] compositeID_0;

		[CompilerGenerated]
		private CompositeID[] compositeID_1;
	}
}
