﻿using System;
using System.Collections.Generic;
using System.Security.Permissions;
using Microsoft.Win32;
using Newtonsoft.Json;

namespace Replikanto.Util
{
	public sealed class Registry
	{
		private Registry()
		{
		}

		public static Registry GetInstance()
		{
			if (Registry.registry_0 == null)
			{
				Registry.registry_0 = new Registry();
				try
				{
					Delegate583.smethod_0(new RegistryPermission(RegistryPermissionAccess.AllAccess, "SOFTWARE\\FlowBots\\Replikanto"), Delegate583.delegate583_0);
					RegistryKey registryKey = Delegate584.smethod_0(Registry.CurrentUser, "SOFTWARE\\FlowBots\\Replikanto", Delegate584.delegate584_0);
					if (registryKey != null)
					{
						Delegate585.smethod_0(registryKey, "check", "1", Delegate585.delegate585_0);
						Delegate586.smethod_0(registryKey, "check", Delegate586.delegate586_0);
					}
					Registry.dictionary_0 = null;
					Registry.smethod_2();
				}
				catch
				{
					Registry.dictionary_0 = Registry.smethod_0();
					if (Registry.dictionary_0 == null)
					{
						Registry.dictionary_0 = new Dictionary<string, string>();
					}
				}
			}
			return Registry.registry_0;
		}

		public void RegKey(string key, string value, out string oldValue, bool saveOld = false)
		{
			oldValue = null;
			if (Registry.dictionary_0 == null)
			{
				RegistryKey registryKey = Delegate584.smethod_0(Registry.CurrentUser, "SOFTWARE\\FlowBots\\Replikanto", Delegate584.delegate584_0);
				if (registryKey != null)
				{
					object obj = Delegate587.smethod_0(registryKey, key, Delegate587.delegate587_0);
					if (obj == null)
					{
						Delegate585.smethod_0(registryKey, key, value, Delegate585.delegate585_0);
						return;
					}
					string text = Delegate86.smethod_0(obj, Delegate86.delegate86_0);
					oldValue = text;
					if (Delegate104.smethod_0(text, value, Delegate104.delegate104_0))
					{
						Delegate585.smethod_0(registryKey, key, value, Delegate585.delegate585_0);
						if (saveOld)
						{
							Delegate585.smethod_0(registryKey, Delegate33.smethod_0("Old", key, Delegate33.delegate33_0), text, Delegate585.delegate585_0);
							return;
						}
					}
				}
			}
			else
			{
				string text2;
				if (Registry.dictionary_0.TryGetValue(key, out text2))
				{
					if (Delegate104.smethod_0(text2, value, Delegate104.delegate104_0))
					{
						if (saveOld)
						{
							Registry.dictionary_0.Add(Delegate33.smethod_0("Old", key, Delegate33.delegate33_0), text2);
						}
						Registry.dictionary_0.Add(key, value);
						Registry.smethod_1();
					}
					oldValue = text2;
					return;
				}
				Registry.dictionary_0.Add(key, value);
				Registry.smethod_1();
			}
		}

		public string GetKey(string key)
		{
			string text;
			try
			{
				string text2;
				if (Registry.dictionary_0 == null)
				{
					RegistryKey registryKey = Delegate584.smethod_0(Registry.CurrentUser, "SOFTWARE\\FlowBots\\Replikanto", Delegate584.delegate584_0);
					if (registryKey == null)
					{
						text = null;
					}
					else
					{
						object obj = Delegate587.smethod_0(registryKey, key, Delegate587.delegate587_0);
						if (obj != null)
						{
							text = Delegate86.smethod_0(obj, Delegate86.delegate86_0);
						}
						else
						{
							text = null;
						}
					}
				}
				else if (!Registry.dictionary_0.TryGetValue(key, out text2))
				{
					text = null;
				}
				else
				{
					text = text2;
				}
			}
			catch
			{
				text = null;
			}
			return text;
		}

		public bool DelKey(string key)
		{
			bool flag;
			try
			{
				if (Registry.dictionary_0 != null)
				{
					if (Registry.dictionary_0.Remove(key))
					{
						if (Registry.dictionary_0.Count == 0)
						{
							Registry.smethod_2();
							flag = true;
						}
						else
						{
							flag = Registry.smethod_1();
						}
					}
					else
					{
						flag = false;
					}
				}
				else
				{
					RegistryKey registryKey = Delegate584.smethod_0(Registry.CurrentUser, "SOFTWARE\\FlowBots\\Replikanto", Delegate584.delegate584_0);
					if (registryKey != null)
					{
						if (Delegate587.smethod_0(registryKey, key, Delegate587.delegate587_0) == null)
						{
							flag = false;
						}
						else
						{
							Delegate586.smethod_0(registryKey, key, Delegate586.delegate586_0);
							flag = true;
						}
					}
					else
					{
						flag = false;
					}
				}
			}
			catch
			{
				flag = false;
			}
			return flag;
		}

		private static Dictionary<string, string> smethod_0()
		{
			if (Delegate508.smethod_0(Delegate33.smethod_0(Delegate87.smethod_0(Delegate87.delegate87_0), "bin\\Custom\\Replikanto_registry.json", Delegate33.delegate33_0), Delegate508.delegate508_0))
			{
				return JsonConvert.DeserializeObject<Dictionary<string, string>>(Delegate85.smethod_0(Delegate33.smethod_0(Delegate87.smethod_0(Delegate87.delegate87_0), "bin\\Custom\\Replikanto_registry.json", Delegate33.delegate33_0), Delegate85.PqjGzimOld));
			}
			return null;
		}

		private static bool smethod_1()
		{
			bool flag;
			try
			{
				string text = JsonConvert.SerializeObject(Registry.dictionary_0, Formatting.Indented);
				Delegate489.smethod_0(Delegate33.smethod_0(Delegate87.smethod_0(Delegate87.delegate87_0), "bin\\Custom\\Replikanto_registry.json", Delegate33.delegate33_0), text, Delegate489.delegate489_0);
				flag = true;
			}
			catch
			{
				flag = false;
			}
			return flag;
		}

		private static void smethod_2()
		{
			try
			{
				Delegate509.smethod_0(Delegate33.smethod_0(Delegate87.smethod_0(Delegate87.delegate87_0), "bin\\Custom\\Replikanto_registry.json", Delegate33.delegate33_0), Delegate509.delegate509_0);
			}
			catch
			{
			}
		}

		internal static void smethod_3()
		{
		}

		internal static object smethod_4(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static void smethod_5()
		{
			Registry.smethod_2();
		}

		internal static bool smethod_6()
		{
			return Registry.smethod_1();
		}

		internal static void smethod_7()
		{
		}

		private static Registry registry_0;

		private static Dictionary<string, string> dictionary_0;
	}
}
