﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Replikanto.Util
{
	public static class ObservableCollectionExtention
	{
		public static IEnumerable<IEnumerable<T>> partition<T>(this IEnumerable<T> values, int chunkSize)
		{
			while (values.Any<T>())
			{
				yield return values.Take(chunkSize).ToList<T>();
				int num;
				if (num != 1)
				{
					yield break;
				}
				values = values.Skip(chunkSize).ToList<T>();
			}
			yield break;
		}

		internal static void smethod_0()
		{
		}
	}
}
