﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using NinjaTrader.Cbi;

namespace Replikanto.Util
{
	public class LeaderAccountsGuard
	{
		public static LeaderAccountsGuard GetInstance()
		{
			object obj = LeaderAccountsGuard.object_0;
			bool flag = false;
			try
			{
				Delegate41.smethod_0(obj, ref flag, Delegate41.delegate41_0);
				if (LeaderAccountsGuard.leaderAccountsGuard_0 == null)
				{
					LeaderAccountsGuard.leaderAccountsGuard_0 = new LeaderAccountsGuard();
				}
			}
			finally
			{
				if (flag)
				{
					Delegate59.smethod_0(obj, Delegate59.delegate59_0);
				}
			}
			return LeaderAccountsGuard.leaderAccountsGuard_0;
		}

		internal void SetLeaderAccount(string workspace, string pageID, Account oldLeaderAccount, Account leaderAccount, Instrument instrument, BindingList<SlaveAccount> followers, ReplikantoProperties properties)
		{
			Tuple<string, string, Instrument> tuple = new Tuple<string, string, Instrument>(workspace, pageID, instrument);
			if (leaderAccount == null)
			{
				this.dictionary_0.Remove(tuple);
				return;
			}
			if (!this.dictionary_0.ContainsKey(tuple))
			{
				this.dictionary_0.Add(tuple, new Tuple<Account, BindingList<SlaveAccount>, ReplikantoProperties>(leaderAccount, followers, properties));
				return;
			}
			this.dictionary_0[tuple] = new Tuple<Account, BindingList<SlaveAccount>, ReplikantoProperties>(leaderAccount, followers, properties);
		}

		internal void ChangeLeaderInstrument(string workspace, string pageID, Account leaderAccount, Instrument oldInstrument, Instrument newInstrument, ReplikantoProperties properties)
		{
			if (leaderAccount != null)
			{
				Tuple<string, string, Instrument> tuple = new Tuple<string, string, Instrument>(workspace, pageID, oldInstrument);
				Tuple<Account, BindingList<SlaveAccount>, ReplikantoProperties> tuple2;
				if (this.dictionary_0.ContainsKey(tuple) && this.dictionary_0.TryGetValue(tuple, out tuple2) && this.dictionary_0.Remove(tuple))
				{
					Tuple<string, string, Instrument> tuple3 = new Tuple<string, string, Instrument>(workspace, pageID, newInstrument);
					this.dictionary_0.Add(tuple3, new Tuple<Account, BindingList<SlaveAccount>, ReplikantoProperties>(leaderAccount, tuple2.Item2, tuple2.Item3));
				}
			}
		}

		internal void ChangeLeaderWorkspace(string workspace, string oldWorkspace, string pageID, Instrument instrument)
		{
			Tuple<string, string, Instrument> tuple = new Tuple<string, string, Instrument>(oldWorkspace, pageID, instrument);
			Tuple<Account, BindingList<SlaveAccount>, ReplikantoProperties> tuple2;
			if (this.dictionary_0.ContainsKey(tuple) && this.dictionary_0.TryGetValue(tuple, out tuple2) && this.dictionary_0.Remove(tuple))
			{
				Tuple<string, string, Instrument> tuple3 = new Tuple<string, string, Instrument>(workspace, pageID, instrument);
				this.dictionary_0.Add(tuple3, tuple2);
			}
		}

		internal bool CanBeFollower(string workspace, string pageID, Account leaderAccount, SlaveAccount followerAccount, Instrument instrument, Instrument coInstrument, ReplikantoProperties properties)
		{
			bool flag = true;
			try
			{
				if (leaderAccount == null)
				{
					return true;
				}
				if (followerAccount.Status == FollowerAccountStatus.Off)
				{
					return true;
				}
				Instrument instrument2 = ((!followerAccount.CrossOrder) ? instrument : coInstrument);
				LinkedList<Account> linkedList = new LinkedList<Account>();
				LinkedListNode<Account> linkedListNode = linkedList.AddFirst(leaderAccount);
				LinkedListNode<Account> linkedListNode2 = linkedList.AddLast(Delegate230.smethod_0(followerAccount, Delegate230.delegate230_0));
				foreach (Tuple<string, string, Instrument> tuple in this.dictionary_0.Keys)
				{
					if (!Delegate102.smethod_0(tuple.Item2, pageID, Delegate102.delegate102_0))
					{
						Tuple<Account, BindingList<SlaveAccount>, ReplikantoProperties> tuple2;
						if (Delegate186.smethod_0(tuple.Item3, Delegate186.delegate186_0) == Delegate186.smethod_0(instrument2, Delegate186.delegate186_0) && this.dictionary_0.TryGetValue(tuple, out tuple2))
						{
							if (Delegate104.smethod_0(tuple.Item1, workspace, Delegate104.delegate104_0) && properties.OnlyActiveWokspace && tuple2.Item3.OnlyActiveWokspace)
							{
								continue;
							}
							foreach (SlaveAccount slaveAccount in tuple2.Item2.ToList<SlaveAccount>())
							{
								if (slaveAccount.Status != FollowerAccountStatus.Off && (!slaveAccount.CrossOrder || followerAccount.CrossOrder) && (slaveAccount.CrossOrder || !followerAccount.CrossOrder))
								{
									if (Delegate225.smethod_0(Delegate230.smethod_0(slaveAccount, Delegate230.delegate230_0), Delegate225.delegate225_0) == Delegate225.smethod_0(linkedListNode.Value, Delegate225.delegate225_0))
									{
										if (linkedList.Contains(tuple2.Item1))
										{
											flag = false;
											break;
										}
										linkedListNode = linkedList.AddBefore(linkedListNode, tuple2.Item1);
									}
									else if (Delegate225.smethod_0(linkedListNode2.Value, Delegate225.delegate225_0) == Delegate225.smethod_0(tuple2.Item1, Delegate225.delegate225_0))
									{
										if (linkedList.Contains(Delegate230.smethod_0(slaveAccount, Delegate230.delegate230_0)))
										{
											flag = false;
											break;
										}
										linkedListNode2 = linkedList.AddAfter(linkedListNode2, Delegate230.smethod_0(slaveAccount, Delegate230.delegate230_0));
									}
									if (Delegate225.smethod_0(linkedListNode.Value, Delegate225.delegate225_0) != Delegate225.smethod_0(linkedListNode2.Value, Delegate225.delegate225_0))
									{
										continue;
									}
									flag = false;
									break;
								}
							}
						}
						if (!flag)
						{
							break;
						}
					}
				}
			}
			catch (Exception)
			{
			}
			return flag;
		}

		internal void Remove(string workspace, string pageID, Instrument instrument)
		{
			Tuple<string, string, Instrument> tuple = new Tuple<string, string, Instrument>(workspace, pageID, instrument);
			this.dictionary_0.Remove(tuple);
		}

		[Conditional("Debug")]
		private void method_0(string string_0)
		{
			Delegate83.smethod_0(Delegate82.smethod_0("LeaderAccountsGuard - {0:yyyy-MM-dd HH:mm:ss.fff} - {1}", Delegate81.smethod_0(Delegate81.delegate81_0), string_0, Delegate82.delegate82_0), 0, Delegate83.delegate83_0);
		}

		internal static FollowerAccountStatus smethod_0(object object_1)
		{
			return object_1.Status;
		}

		internal static bool smethod_1(object object_1)
		{
			return object_1.OnlyActiveWokspace;
		}

		internal static bool smethod_2(object object_1)
		{
			return object_1.CrossOrder;
		}

		internal static void smethod_3()
		{
		}

		internal static void smethod_4()
		{
		}

		private static readonly object object_0 = new object();

		private static LeaderAccountsGuard leaderAccountsGuard_0;

		private Dictionary<Tuple<string, string, Instrument>, Tuple<Account, BindingList<SlaveAccount>, ReplikantoProperties>> dictionary_0 = new Dictionary<Tuple<string, string, Instrument>, Tuple<Account, BindingList<SlaveAccount>, ReplikantoProperties>>();
	}
}
