﻿using System;
using System.Collections.Generic;
using System.Reflection;
using Newtonsoft.Json;
using Newtonsoft.Json.Serialization;

namespace Replikanto.Util
{
	public class IgnorePropertiesResolver : DefaultContractResolver
	{
		public IgnorePropertiesResolver(IEnumerable<string> propNamesToIgnore)
		{
			this.hashSet_0 = new HashSet<string>(propNamesToIgnore);
		}

		protected override JsonProperty CreateProperty(MemberInfo member, MemberSerialization memberSerialization)
		{
			JsonProperty jsonProperty = base.CreateProperty(member, memberSerialization);
			if (this.hashSet_0.Contains(jsonProperty.PropertyName))
			{
				jsonProperty.ShouldSerialize = new Predicate<object>(IgnorePropertiesResolver.<>c.BhxjBjErfm.method_0);
			}
			return jsonProperty;
		}

		internal static object smethod_0(object object_0, object object_1, MemberSerialization memberSerialization_0)
		{
			return object_0.CreateProperty(object_1, memberSerialization_0);
		}

		internal static object smethod_1(object object_0)
		{
			return object_0.PropertyName;
		}

		private readonly HashSet<string> hashSet_0;
	}
}
