﻿using System;

namespace System.Threading.Tasks
{
	internal static class TaskExtensions
	{
		public static Task ContinueWithState<TState>(this Task task, Action<Task, TState> continuationAction, TState state)
		{
			return task.ContinueWith(delegate(Task t, object tupleObject)
			{
				ValueTuple<Action<Task, TState>, TState> valueTuple = (ValueTuple<Action<Task, TState>, TState>)tupleObject;
				Action<Task, TState> item = valueTuple.Item1;
				TState item2 = valueTuple.Item2;
				item(t, item2);
			}, new ValueTuple<Action<Task, TState>, TState>(continuationAction, state));
		}

		public static Task ContinueWithState<TState>(this Task task, Action<Task, TState> continuationAction, TState state, CancellationToken cancellationToken)
		{
			return task.ContinueWith(delegate(Task t, object tupleObject)
			{
				ValueTuple<Action<Task, TState>, TState> valueTuple = (ValueTuple<Action<Task, TState>, TState>)tupleObject;
				Action<Task, TState> item = valueTuple.Item1;
				TState item2 = valueTuple.Item2;
				item(t, item2);
			}, new ValueTuple<Action<Task, TState>, TState>(continuationAction, state), cancellationToken);
		}

		public static Task ContinueWithState<TState>(this Task task, Action<Task, TState> continuationAction, TState state, TaskContinuationOptions continuationOptions)
		{
			return task.ContinueWith(delegate(Task t, object tupleObject)
			{
				ValueTuple<Action<Task, TState>, TState> valueTuple = (ValueTuple<Action<Task, TState>, TState>)tupleObject;
				Action<Task, TState> item = valueTuple.Item1;
				TState item2 = valueTuple.Item2;
				item(t, item2);
			}, new ValueTuple<Action<Task, TState>, TState>(continuationAction, state), continuationOptions);
		}

		public static Task ContinueWithState<TState>(this Task task, Action<Task, TState> continuationAction, TState state, CancellationToken cancellationToken, TaskContinuationOptions continuationOptions)
		{
			return task.ContinueWith(delegate(Task t, object tupleObject)
			{
				ValueTuple<Action<Task, TState>, TState> valueTuple = (ValueTuple<Action<Task, TState>, TState>)tupleObject;
				Action<Task, TState> item = valueTuple.Item1;
				TState item2 = valueTuple.Item2;
				item(t, item2);
			}, new ValueTuple<Action<Task, TState>, TState>(continuationAction, state), cancellationToken, continuationOptions, TaskScheduler.Default);
		}

		public static Task ContinueWithState<TResult, TState>(this Task<TResult> task, Action<Task<TResult>, TState> continuationAction, TState state)
		{
			return task.ContinueWith(delegate(Task<TResult> t, object tupleObject)
			{
				ValueTuple<Action<Task<TResult>, TState>, TState> valueTuple = (ValueTuple<Action<Task<TResult>, TState>, TState>)tupleObject;
				Action<Task<TResult>, TState> item = valueTuple.Item1;
				TState item2 = valueTuple.Item2;
				item(t, item2);
			}, new ValueTuple<Action<Task<TResult>, TState>, TState>(continuationAction, state));
		}

		public static Task ContinueWithState<TResult, TState>(this Task<TResult> task, Action<Task<TResult>, TState> continuationAction, TState state, CancellationToken cancellationToken)
		{
			return task.ContinueWith(delegate(Task<TResult> t, object tupleObject)
			{
				ValueTuple<Action<Task<TResult>, TState>, TState> valueTuple = (ValueTuple<Action<Task<TResult>, TState>, TState>)tupleObject;
				Action<Task<TResult>, TState> item = valueTuple.Item1;
				TState item2 = valueTuple.Item2;
				item(t, item2);
			}, new ValueTuple<Action<Task<TResult>, TState>, TState>(continuationAction, state), cancellationToken);
		}

		public static Task ContinueWithState<TResult, TState>(this Task<TResult> task, Action<Task<TResult>, TState> continuationAction, TState state, TaskContinuationOptions continuationOptions)
		{
			return task.ContinueWith(delegate(Task<TResult> t, object tupleObject)
			{
				ValueTuple<Action<Task<TResult>, TState>, TState> valueTuple = (ValueTuple<Action<Task<TResult>, TState>, TState>)tupleObject;
				Action<Task<TResult>, TState> item = valueTuple.Item1;
				TState item2 = valueTuple.Item2;
				item(t, item2);
			}, new ValueTuple<Action<Task<TResult>, TState>, TState>(continuationAction, state), continuationOptions);
		}

		public static Task ContinueWithState<TResult, TState>(this Task<TResult> task, Action<Task<TResult>, TState> continuationAction, TState state, CancellationToken cancellationToken, TaskContinuationOptions continuationOptions)
		{
			return task.ContinueWith(delegate(Task<TResult> t, object tupleObject)
			{
				ValueTuple<Action<Task<TResult>, TState>, TState> valueTuple = (ValueTuple<Action<Task<TResult>, TState>, TState>)tupleObject;
				Action<Task<TResult>, TState> item = valueTuple.Item1;
				TState item2 = valueTuple.Item2;
				item(t, item2);
			}, new ValueTuple<Action<Task<TResult>, TState>, TState>(continuationAction, state), cancellationToken, continuationOptions, TaskScheduler.Default);
		}
	}
}
