﻿using System;
using System.Collections.Generic;
using System.Diagnostics;

namespace System.Threading.Channels
{
	internal sealed class DebugEnumeratorDebugView<T>
	{
		public DebugEnumeratorDebugView(IDebugEnumerable<T> enumerable)
		{
			List<T> list = new List<T>();
			foreach (T t in enumerable)
			{
				list.Add(t);
			}
			this.Items = list.ToArray();
		}

		[DebuggerBrowsable(DebuggerBrowsableState.RootHidden)]
		public T[] Items { get; }
	}
}
