﻿using System;
using System.Runtime.CompilerServices;

namespace System.Threading.Channels
{
	[Nullable(0)]
	[NullableContext(2)]
	public class ChannelClosedException : InvalidOperationException
	{
		public ChannelClosedException()
			: base(SR.ChannelClosedException_DefaultMessage)
		{
		}

		public ChannelClosedException(string message)
			: base(message)
		{
		}

		public ChannelClosedException(Exception innerException)
			: base(SR.ChannelClosedException_DefaultMessage, innerException)
		{
		}

		public ChannelClosedException(string message, Exception innerException)
			: base(message, innerException)
		{
		}
	}
}
