﻿using System;
using System.Runtime.CompilerServices;

namespace System.Threading.Channels
{
	[Nullable(0)]
	[NullableContext(1)]
	public abstract class Channel<[Nullable(2)] TWrite, [Nullable(2)] TRead>
	{
		public ChannelReader<TRead> Reader { get; protected set; }

		public ChannelWriter<TWrite> Writer { get; protected set; }

		public static implicit operator ChannelReader<TRead>(Channel<TWrite, TRead> channel)
		{
			return channel.Reader;
		}

		public static implicit operator ChannelWriter<TWrite>(Channel<TWrite, TRead> channel)
		{
			return channel.Writer;
		}
	}
}
