﻿using System;

namespace System.Threading.Channels
{
	public sealed class BoundedChannelOptions : ChannelOptions
	{
		public BoundedChannelOptions(int capacity)
		{
			if (capacity < 1)
			{
				throw new ArgumentOutOfRangeException("capacity");
			}
			this.Capacity = capacity;
		}

		public int Capacity
		{
			get
			{
				return this._capacity;
			}
			set
			{
				if (value < 1)
				{
					throw new ArgumentOutOfRangeException("value");
				}
				this._capacity = value;
			}
		}

		public BoundedChannelFullMode FullMode
		{
			get
			{
				return this._mode;
			}
			set
			{
				if (value > BoundedChannelFullMode.DropWrite)
				{
					throw new ArgumentOutOfRangeException("value");
				}
				this._mode = value;
			}
		}

		private int _capacity;

		private BoundedChannelFullMode _mode;
	}
}
