﻿using System;

namespace System.Threading.Channels
{
	internal abstract class AsyncOperation
	{
		private static void AvailableSentinel(object s)
		{
		}

		private static void CompletedSentinel(object s)
		{
		}

		protected static void ThrowIncompleteOperationException()
		{
			throw new InvalidOperationException(SR.InvalidOperation_IncompleteAsyncOperation);
		}

		protected static void ThrowMultipleContinuations()
		{
			throw new InvalidOperationException(SR.InvalidOperation_MultipleContinuations);
		}

		protected static void ThrowIncorrectCurrentIdException()
		{
			throw new InvalidOperationException(SR.InvalidOperation_IncorrectToken);
		}

		protected static readonly Action<object> s_availableSentinel = new Action<object>(AsyncOperation.AvailableSentinel);

		protected static readonly Action<object> s_completedSentinel = new Action<object>(AsyncOperation.CompletedSentinel);
	}
}
