﻿using System;
using System.Resources;
using FxResources.System.Threading.Channels;

namespace System
{
	internal static class SR
	{
		private static bool UsingResourceKeys()
		{
			return global::System.SR.s_usingResourceKeys;
		}

		internal static string GetResourceString(string resourceKey)
		{
			if (global::System.SR.s_usingResourceKeys)
			{
				return resourceKey;
			}
			string text = null;
			try
			{
				text = global::System.SR.ResourceManager.GetString(resourceKey);
			}
			catch (MissingManifestResourceException)
			{
			}
			return text;
		}

		internal static string GetResourceString(string resourceKey, string defaultString)
		{
			string resourceString = global::System.SR.GetResourceString(resourceKey);
			if (!(resourceKey == resourceString) && resourceString != null)
			{
				return resourceString;
			}
			return defaultString;
		}

		internal static string Format(string resourceFormat, object p1)
		{
			if (global::System.SR.s_usingResourceKeys)
			{
				return string.Join(", ", new object[] { resourceFormat, p1 });
			}
			return string.Format(resourceFormat, p1);
		}

		internal static string Format(string resourceFormat, object p1, object p2)
		{
			if (global::System.SR.s_usingResourceKeys)
			{
				return string.Join(", ", new object[] { resourceFormat, p1, p2 });
			}
			return string.Format(resourceFormat, p1, p2);
		}

		internal static string Format(string resourceFormat, object p1, object p2, object p3)
		{
			if (global::System.SR.s_usingResourceKeys)
			{
				return string.Join(", ", new object[] { resourceFormat, p1, p2, p3 });
			}
			return string.Format(resourceFormat, p1, p2, p3);
		}

		internal static string Format(string resourceFormat, params object[] args)
		{
			if (args == null)
			{
				return resourceFormat;
			}
			if (global::System.SR.s_usingResourceKeys)
			{
				return resourceFormat + ", " + string.Join(", ", args);
			}
			return string.Format(resourceFormat, args);
		}

		internal static string Format(IFormatProvider provider, string resourceFormat, object p1)
		{
			if (global::System.SR.s_usingResourceKeys)
			{
				return string.Join(", ", new object[] { resourceFormat, p1 });
			}
			return string.Format(provider, resourceFormat, p1);
		}

		internal static string Format(IFormatProvider provider, string resourceFormat, object p1, object p2)
		{
			if (global::System.SR.s_usingResourceKeys)
			{
				return string.Join(", ", new object[] { resourceFormat, p1, p2 });
			}
			return string.Format(provider, resourceFormat, p1, p2);
		}

		internal static string Format(IFormatProvider provider, string resourceFormat, object p1, object p2, object p3)
		{
			if (global::System.SR.s_usingResourceKeys)
			{
				return string.Join(", ", new object[] { resourceFormat, p1, p2, p3 });
			}
			return string.Format(provider, resourceFormat, p1, p2, p3);
		}

		internal static string Format(IFormatProvider provider, string resourceFormat, params object[] args)
		{
			if (args == null)
			{
				return resourceFormat;
			}
			if (global::System.SR.s_usingResourceKeys)
			{
				return resourceFormat + ", " + string.Join(", ", args);
			}
			return string.Format(provider, resourceFormat, args);
		}

		internal static ResourceManager ResourceManager
		{
			get
			{
				ResourceManager resourceManager;
				if ((resourceManager = global::System.SR.s_resourceManager) == null)
				{
					resourceManager = (global::System.SR.s_resourceManager = new ResourceManager(typeof(FxResources.System.Threading.Channels.SR)));
				}
				return resourceManager;
			}
		}

		internal static string ChannelClosedException_DefaultMessage
		{
			get
			{
				return global::System.SR.GetResourceString("ChannelClosedException_DefaultMessage");
			}
		}

		internal static string InvalidOperation_IncompleteAsyncOperation
		{
			get
			{
				return global::System.SR.GetResourceString("InvalidOperation_IncompleteAsyncOperation");
			}
		}

		internal static string InvalidOperation_MultipleContinuations
		{
			get
			{
				return global::System.SR.GetResourceString("InvalidOperation_MultipleContinuations");
			}
		}

		internal static string InvalidOperation_IncorrectToken
		{
			get
			{
				return global::System.SR.GetResourceString("InvalidOperation_IncorrectToken");
			}
		}

		// Note: this type is marked as 'beforefieldinit'.
		static SR()
		{
			bool flag;
			global::System.SR.s_usingResourceKeys = AppContext.TryGetSwitch("System.Resources.UseSystemResourceKeys", out flag) && flag;
		}

		private static readonly bool s_usingResourceKeys;

		private static ResourceManager s_resourceManager;
	}
}
