﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Runtime.CompilerServices;

namespace System.Reactive
{
	[Serializable]
	public struct TimeInterval<T> : IEquatable<TimeInterval<T>>
	{
		public TimeInterval(T value, TimeSpan interval)
		{
			this.Interval = interval;
			this.Value = value;
		}

		public T Value
		{
			[IsReadOnlyAttribute{5A691055-D045-4E5A-854F-8B26A5346F0C}]
			get;
		}

		public TimeSpan Interval
		{
			[IsReadOnlyAttribute{5A691055-D045-4E5A-854F-8B26A5346F0C}]
			get;
		}

		public bool Equals(TimeInterval<T> other)
		{
			return other.Interval.Equals(this.Interval) && EqualityComparer<T>.Default.Equals(this.Value, other.Value);
		}

		public static bool operator ==(TimeInterval<T> first, TimeInterval<T> second)
		{
			return first.Equals(second);
		}

		public static bool operator !=(TimeInterval<T> first, TimeInterval<T> second)
		{
			return !first.Equals(second);
		}

		public override bool Equals(object obj)
		{
			if (!(obj is TimeInterval<T>))
			{
				return false;
			}
			TimeInterval<T> timeInterval = (TimeInterval<T>)obj;
			return this.Equals(timeInterval);
		}

		public override int GetHashCode()
		{
			int hashCode = this.Interval.GetHashCode();
			T value = this.Value;
			return hashCode ^ ((value != null) ? value.GetHashCode() : 1963);
		}

		public override string ToString()
		{
			return string.Format(CultureInfo.CurrentCulture, "{0}@{1}", this.Value, this.Interval);
		}
	}
}
