﻿using System;

namespace System.Reactive
{
	internal sealed class SynchronizedObserver<T> : ObserverBase<T>
	{
		public SynchronizedObserver(IObserver<T> observer, object gate)
		{
			this._gate = gate;
			this._observer = observer;
		}

		protected override void OnNextCore(T value)
		{
			object gate = this._gate;
			lock (gate)
			{
				this._observer.OnNext(value);
			}
		}

		protected override void OnErrorCore(Exception exception)
		{
			object gate = this._gate;
			lock (gate)
			{
				this._observer.OnError(exception);
			}
		}

		protected override void OnCompletedCore()
		{
			object gate = this._gate;
			lock (gate)
			{
				this._observer.OnCompleted();
			}
		}

		private readonly object _gate;

		private readonly IObserver<T> _observer;
	}
}
