﻿using System;
using System.ComponentModel;

namespace System.Reactive.PlatformServices
{
	[EditorBrowsable(EditorBrowsableState.Never)]
	public class SystemClockChangedEventArgs : EventArgs
	{
		public SystemClockChangedEventArgs()
			: this(DateTimeOffset.MinValue, DateTimeOffset.MaxValue)
		{
		}

		public SystemClockChangedEventArgs(DateTimeOffset oldTime, DateTimeOffset newTime)
		{
			this.OldTime = oldTime;
			this.NewTime = newTime;
		}

		public DateTimeOffset OldTime { get; }

		public DateTimeOffset NewTime { get; }
	}
}
