﻿using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Reactive.Concurrency;
using System.Reactive.Linq;
using System.Reflection;

namespace System.Reactive.PlatformServices
{
	[EditorBrowsable(EditorBrowsableState.Never)]
	public class CurrentPlatformEnlightenmentProvider : IPlatformEnlightenmentProvider
	{
		public virtual T GetService<T>(object[] args) where T : class
		{
			Type typeFromHandle = typeof(T);
			if (typeFromHandle == typeof(GInterface6))
			{
				return (T)((object)new ExceptionServicesImpl());
			}
			if (typeFromHandle == typeof(IConcurrencyAbstractionLayer))
			{
				return (T)((object)new ConcurrencyAbstractionLayerImpl());
			}
			if (typeFromHandle == typeof(IScheduler) && args != null)
			{
				string text = (string)args[0];
				if (text != null)
				{
					if (text == "ThreadPool")
					{
						return (T)((object)ThreadPoolScheduler.Instance);
					}
					if (text == "TaskPool")
					{
						return (T)((object)TaskPoolScheduler.Default);
					}
					if (text == "NewThread")
					{
						return (T)((object)NewThreadScheduler.Default);
					}
				}
			}
			if (typeFromHandle == typeof(IQueryServices) && Debugger.IsAttached)
			{
				AssemblyName assemblyName = new AssemblyName(typeFromHandle.Assembly.FullName)
				{
					Name = "System.Reactive"
				};
				Type type = Type.GetType("System.Reactive.Linq.QueryDebugger, " + assemblyName.FullName, false);
				if (type != null)
				{
					return (T)((object)Activator.CreateInstance(type));
				}
			}
			return default(T);
		}
	}
}
